/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 1996 Microsoft Corporation. All rights reserved.
 * 
 * Description:
 * Trebuchet, designed by Vincent Connare in 1996, is a humanist sans serif
 * designed for easy screen readability. Trebuchet takes its inspiration from the
 * sans serifs of the 1930s which had large x heights and round features intended
 * to promote readability on signs. The typeface name is credited to a puzzle heard
 * at Microsoft, where the question was asked, "could you build a Trebuchet (a form
 * of medieval catapult) to launch a person from the main campus to the consumer
 * campus, and how?" The Trebuchet fonts are intended to be the vehicle that fires
 * your messages across the Internet. "Launch your message with a Trebuchet page".
 * 
 * Manufacturer:
 * Microsoft Corp.
 * 
 * Designer:
 * Vincent Connare
 * 
 * Vendor URL:
 * http://www.microsoft.com
 */
Cufon.registerFont({"w":188,"face":{"font-family":"Trebuchet MS","font-weight":400,"font-style":"italic","font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 3 2 2 2 9 2 4","ascent":"288","descent":"-72","x-height":"4","bbox":"-40 -340 399 93","underline-thickness":"22.3242","underline-position":"-34.8047","slope":"-10","unicode-range":"U+0020-U+F007"},"glyphs":{" ":{"w":108,"k":{"Y":7,"A":13}},"!":{"d":"62,-67r-13,0v0,-95,8,-123,21,-195r40,0v-14,80,-16,98,-48,195xm23,-21v0,-14,11,-25,25,-25v14,0,25,11,25,25v0,14,-12,25,-25,25v-13,0,-25,-11,-25,-25","w":132},"\"":{"d":"57,-191r-23,0r7,-67r33,0xm115,-191r-23,0r7,-67r33,0","w":116},"#":{"d":"165,-166r-18,69r29,0r0,22r-34,0r-22,79r-23,0r22,-79r-52,0r-22,79r-23,0r22,-79r-27,0r0,-22r33,0r17,-69r-30,0r0,-23r36,0r18,-72r23,0r-18,72r52,0r18,-72r22,0r-18,72r31,0r0,23r-36,0xm90,-166r-17,69r52,0r17,-69r-52,0"},"$":{"d":"77,-192v8,53,87,55,87,124v0,45,-30,68,-73,72r-5,28r-27,0r4,-29v-18,-2,-32,-6,-43,-11r11,-34v26,20,102,23,98,-24v-5,-55,-89,-58,-87,-122v0,-41,26,-68,64,-73r6,-35r28,0r-6,34v21,1,34,4,40,7r-10,34v-26,-20,-93,-14,-87,29","w":173},"%":{"d":"25,4r-22,0r202,-266r22,0xm123,-219v0,40,-23,79,-62,78v-26,0,-39,-15,-39,-43v0,-41,18,-78,62,-78v26,0,39,14,39,43xm81,-244v-24,0,-38,30,-37,57v0,19,6,28,19,28v27,2,38,-35,38,-60v0,-17,-7,-25,-20,-25xm216,-75v1,39,-22,78,-62,78v-26,0,-40,-15,-40,-43v0,-41,20,-79,63,-78v26,0,39,14,39,43xm173,-100v-23,0,-37,32,-36,57v0,19,6,28,19,28v27,2,38,-35,38,-60v0,-17,-8,-25,-21,-25","w":216},"&":{"d":"172,-221v-30,-32,-92,-10,-89,36v0,12,5,22,15,30r65,0r6,-32r34,-5r-7,38r44,0r-5,28r-44,0v-4,25,-12,48,-12,77v0,29,30,27,46,13r0,32v-18,10,-57,13,-72,-5v-50,25,-128,15,-128,-49v0,-35,14,-64,42,-88v-44,-51,3,-116,70,-116v20,0,35,2,44,8xm88,-126v-35,31,-41,100,19,100v24,0,40,-3,39,-29r12,-71r-70,0","w":254},"'":{"d":"57,-191r-23,0r7,-67r33,0","w":57},"(":{"d":"81,75v-60,-49,-63,-166,-19,-247v23,-42,45,-72,74,-87r0,14v-55,58,-90,200,-55,302r0,18","w":132},")":{"d":"61,-259v33,13,52,77,52,125v0,84,-52,177,-109,209r0,-18v53,-45,96,-213,57,-302r0,-14","w":132},"*":{"d":"141,-203v-11,6,-29,5,-46,5v13,9,28,16,36,30r-21,18v-11,-11,-17,-26,-24,-40r-24,40r-23,-18v7,-14,23,-19,37,-27v-16,-3,-33,-5,-47,-10r13,-27v16,5,27,15,39,24v-4,-17,-13,-28,-12,-50r31,0v1,21,-7,33,-10,50v13,-8,24,-19,41,-24","w":132},"+":{"d":"107,-124r62,0r0,25r-62,0r0,60r-24,0r0,-60r-62,0r0,-25r62,0r0,-60r24,0r0,60"},",":{"d":"65,-51v33,2,30,48,13,70v-10,12,-24,26,-46,40r-8,-13v23,-15,34,-29,34,-42v0,-14,-20,-21,-17,-34v0,-12,12,-21,24,-21","w":132},"-":{"d":"25,-89r6,-31r75,0r-5,31r-76,0","w":132},"\u2010":{"d":"25,-89r6,-31r75,0r-5,31r-76,0","w":132},".":{"d":"29,-23v0,-14,12,-26,26,-26v15,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27","w":132},"\/":{"d":"62,0r-29,0r94,-259r28,0"},"0":{"d":"78,4v-44,0,-66,-31,-66,-77v0,-96,30,-189,115,-189v43,0,65,25,65,74v0,101,-28,192,-114,192xm121,-232v-51,1,-74,93,-74,152v0,36,12,54,34,54v58,0,76,-88,75,-159v0,-32,-11,-47,-35,-47"},"1":{"d":"78,0r34,-194r-52,27r5,-34v41,-19,68,-38,83,-58r11,0r-46,259r-35,0"},"2":{"d":"103,-262v58,0,89,45,62,94v-22,39,-71,97,-100,136r95,0r-5,32r-144,0r0,-16r85,-108v24,-35,38,-41,42,-79v-4,-37,-64,-38,-79,-5r-25,-16v11,-25,34,-38,69,-38"},"3":{"d":"164,-85v-1,63,-34,89,-101,89v-23,0,-42,-8,-55,-23r16,-29v28,39,103,21,103,-36v0,-26,-16,-39,-47,-39r5,-29v36,0,54,-15,54,-47v0,-38,-48,-41,-70,-21r-16,-21v32,-37,124,-25,124,37v0,33,-25,57,-51,66v25,9,38,27,38,53"},"4":{"d":"155,-70r-12,70r-35,0r12,-70r-116,0r4,-20r168,-169r12,0r-28,162r26,0r-5,27r-26,0xm140,-187r-89,90r74,0"},"5":{"d":"71,-26v65,0,92,-115,22,-120v-24,-2,-30,16,-56,13r22,-126r128,0r-6,30r-94,0r-11,63v39,-26,96,2,96,51v0,79,-36,119,-106,119v-22,0,-40,-7,-52,-19r14,-31v14,13,28,20,43,20"},"6":{"d":"180,-99v0,52,-39,103,-91,103v-78,0,-79,-90,-54,-147v18,-41,71,-109,119,-119r14,19v-20,6,-90,75,-94,96v39,-31,106,-9,106,48xm110,-131v-36,0,-57,29,-56,67v0,26,12,39,37,39v31,0,53,-34,52,-67v0,-22,-11,-39,-33,-39"},"7":{"d":"60,0r-42,0v21,-44,67,-119,138,-225r-124,0r6,-34r168,0r0,14v-61,85,-109,167,-146,245"},"8":{"d":"15,-58v0,-44,28,-71,61,-85v-15,-8,-28,-30,-28,-52v0,-42,34,-67,78,-67v34,0,63,21,63,52v0,31,-23,63,-49,70v20,10,36,33,36,59v0,60,-29,85,-91,85v-38,0,-70,-25,-70,-62xm120,-232v-30,-1,-50,38,-27,59v6,7,13,12,22,16v34,-4,59,-74,5,-75xm104,-127v-45,3,-81,95,-16,101v65,6,65,-86,16,-101"},"9":{"d":"122,-262v101,0,73,141,22,199v-33,37,-60,61,-88,67r-13,-18v20,-6,89,-75,94,-96v-41,31,-106,3,-106,-52v0,-59,34,-100,91,-100xm101,-126v35,0,55,-29,55,-68v0,-23,-13,-38,-37,-38v-53,0,-75,106,-18,106"},":":{"d":"51,-162v0,-14,12,-26,27,-26v14,0,26,12,26,26v0,14,-12,27,-26,27v-14,0,-27,-13,-27,-27xm36,-23v0,-14,12,-26,26,-26v15,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27","w":132},";":{"d":"51,-162v0,-14,12,-26,27,-26v14,0,26,12,26,26v0,14,-12,27,-26,27v-14,0,-27,-13,-27,-27xm65,-51v33,2,30,48,13,70v-10,12,-24,26,-46,40r-8,-13v23,-15,34,-29,34,-42v0,-14,-20,-21,-17,-34v0,-12,12,-21,24,-21","w":132},"<":{"d":"156,-38r-130,-63r0,-22r130,-62r0,28r-100,45r100,45r0,29"},"=":{"d":"169,-154r0,25r-148,0r0,-25r148,0xm169,-94r0,25r-148,0r0,-25r148,0"},">":{"d":"175,-101r-130,63r0,-29r100,-45r-100,-45r0,-28r130,62r0,22"},"?":{"d":"39,-248v30,-24,108,-20,108,36v0,68,-81,73,-87,137r-17,0v-15,-68,63,-77,71,-136v4,-30,-48,-28,-64,-14xm26,-21v0,-14,11,-25,25,-25v14,0,25,12,25,25v0,13,-12,25,-25,25v-13,0,-25,-11,-25,-25","w":132},"@":{"d":"199,-45v-14,0,-33,-7,-36,-17v-18,28,-81,26,-81,-21v0,-56,63,-106,120,-71v-10,42,-15,67,-15,73v0,12,5,18,15,18v30,-1,44,-39,44,-72v0,-46,-33,-76,-79,-76v-68,0,-120,64,-120,132v0,81,99,102,152,59r17,12v-62,59,-195,35,-195,-67v0,-83,68,-158,150,-158v59,0,100,33,100,92v0,45,-28,96,-72,96xm175,-141v-31,-28,-65,24,-65,56v0,27,27,28,42,14v17,-16,16,-45,23,-70","w":277},"A":{"d":"165,0r-9,-54r-92,0r-30,54r-40,0r151,-261r9,0r51,261r-40,0xm137,-190r-59,110r75,0","w":219,"k":{"\u2019":45,"y":14,"w":26,"v":29,"Y":43,"W":36,"V":44,"T":40," ":13}},"B":{"d":"195,-85v-1,84,-86,93,-180,85r46,-258v65,-11,139,2,139,57v0,27,-24,54,-48,57v29,5,43,25,43,59xm92,-229r-11,71v46,5,83,-6,83,-44v0,-27,-38,-33,-72,-27xm57,-30v46,7,101,-7,101,-51v0,-39,-36,-54,-83,-48","w":203},"C":{"d":"25,-93v0,-104,77,-199,187,-161r-10,35v-73,-46,-140,46,-140,119v0,81,76,91,121,47r-3,38v-14,13,-37,19,-67,19v-57,0,-88,-39,-88,-97","w":215},"D":{"d":"219,-158v0,95,-61,159,-151,158r-56,0r45,-258v85,-16,162,14,162,100xm181,-160v0,-48,-44,-81,-95,-67r-32,194v82,11,127,-51,127,-127","w":220},"E":{"d":"85,-226r-13,72r86,0r-6,30r-85,0r-16,92r117,0r-6,32r-154,0r46,-258r155,0r-5,32r-119,0","w":192},"F":{"d":"86,-226r-12,72r90,0r-5,30r-90,0r-22,124r-37,0r46,-258r160,0r-6,32r-124,0","k":{"A":40,".":70,",":70," ":7}},"G":{"d":"20,-95v0,-94,61,-168,152,-167v25,0,42,5,52,15r-10,33v-77,-50,-157,24,-157,112v0,73,72,94,119,58r11,-60r-36,0r5,-30r71,0r-20,112v-24,18,-55,26,-93,26v-63,0,-94,-33,-94,-99","w":243},"H":{"d":"160,0r22,-124r-112,0r-22,124r-36,0r45,-258r37,0r-19,104r113,0r18,-104r36,0r-46,258r-36,0","w":235},"I":{"d":"13,0r46,-258r36,0r-46,258r-36,0","w":100},"J":{"d":"113,-19v-25,34,-130,34,-115,-33r30,0v-3,32,45,26,59,14v28,-45,33,-155,48,-220r36,0v-18,76,-21,187,-58,239","w":171},"K":{"d":"153,0r-50,-118r-43,48r-12,70r-36,0r45,-258r36,0r-23,134r117,-134r41,0r-97,112r62,146r-40,0","w":207},"L":{"d":"15,0r45,-258r36,0r-40,226r117,0r-6,32r-152,0","w":182,"k":{"\u2019":38,"y":16,"Y":44,"W":30,"V":31,"T":37," ":7}},"M":{"d":"219,0r-3,-159r-86,163r-9,0r-27,-165r-60,161r-33,0r91,-258r18,0r28,181r91,-181r18,0r8,258r-36,0","w":274},"N":{"d":"176,4r-100,-183r-30,179r-36,0r46,-258r14,0r98,176r30,-176r35,0r-46,262r-11,0","w":229},"O":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-53,0,-91,79,-90,132v0,39,16,71,52,72v62,0,96,-71,95,-137v0,-44,-19,-67,-57,-67","w":242},"P":{"d":"205,-186v0,70,-69,103,-141,87r-18,99r-37,0r47,-258v79,-11,149,4,149,72xm69,-131v42,15,99,-5,99,-52v0,-44,-41,-54,-82,-43","w":195,"k":{"A":43,".":70,",":70," ":13}},"Q":{"d":"148,-262v142,0,95,229,13,254v9,36,72,51,105,25r15,27v-8,11,-39,21,-62,21v-48,0,-82,-26,-90,-65v-68,18,-111,-26,-111,-95v0,-83,50,-167,130,-167xm145,-231v-54,0,-90,77,-90,132v0,40,15,71,51,72v62,0,97,-71,96,-137v0,-44,-19,-67,-57,-67","w":242},"R":{"d":"206,-204v0,43,-31,81,-67,87r48,117r-40,0r-41,-111v-9,0,-21,0,-37,-1r-20,112r-37,0r46,-258v65,-4,148,-9,148,54xm168,-189v1,-40,-38,-42,-79,-37r-15,84v46,8,94,-6,94,-47","w":209,"k":{"Y":24,"W":16,"V":20,"T":17}},"S":{"d":"148,-107v43,77,-49,142,-133,99r11,-34v26,20,102,23,98,-24v-5,-55,-87,-58,-87,-122v0,-67,79,-87,132,-67r-10,34v-31,-25,-108,-7,-83,44v13,24,58,44,72,70","w":173},"T":{"d":"146,-226r-40,226r-36,0r40,-226r-82,0r5,-32r203,0r-6,32r-84,0","w":209,"k":{"y":34,"w":39,"u":39,"s":39,"r":37,"o":42,"i":9,"e":44,"c":44,"a":44,"O":17,"A":40,";":26,":":26,".":53,"-":40,",":53}},"U":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61","w":233},"V":{"d":"99,4r-18,0r-50,-262r39,0r33,188r95,-188r40,0","w":211,"k":{"y":8,"u":14,"r":22,"o":29,"i":9,"e":24,"a":24,"A":44,";":7,":":7,".":48,"-":20,",":48}},"W":{"d":"209,4r-11,0r-30,-174r-89,174r-11,0r-35,-262r36,0r21,175r88,-175r12,0r26,174r81,-174r38,0","w":306,"k":{"i":6,"e":23,"a":17,"A":31,".":35,"-":17,",":45}},"X":{"d":"144,0r-43,-99r-73,99r-41,0r99,-135r-47,-123r36,0r35,95r74,-95r40,0r-100,127r59,131r-39,0","w":200},"Y":{"d":"126,-115r-21,115r-35,0r20,-115r-58,-143r37,0r43,110r82,-110r39,0","w":205,"k":{"v":20,"u":29,"q":40,"p":29,"o":37,"i":11,"e":38,"a":37,"A":46,";":13,":":13,".":53,"-":40,",":53," ":7}},"Z":{"d":"14,0r0,-9r144,-217r-109,0r5,-32r154,0r0,9r-139,217r108,0r-5,32r-158,0","w":198},"[":{"d":"4,74r60,-339r83,0r-5,29r-47,0r-49,280r46,0r-5,30r-83,0","w":132},"\\":{"d":"86,0r-53,-259r24,0r54,259r-25,0","w":127},"]":{"d":"82,74r-83,0r5,-30r46,0r49,-280r-46,0r6,-29r83,0","w":132},"^":{"d":"159,-159r-43,-79r-43,79r-22,0r56,-100r19,0r56,100r-23,0"},"_":{"d":"-1,45r0,-23r190,0r0,23r-190,0"},"`":{"d":"116,-215r-27,-59r34,0r11,59r-18,0"},"a":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115","w":189},"b":{"d":"191,-109v0,58,-50,115,-107,113v-19,0,-32,-8,-40,-22r-17,22r-22,0v25,-79,35,-181,53,-269r32,0r-15,97v36,-54,116,-9,116,59xm52,-46v34,57,103,-9,103,-60v0,-57,-62,-80,-85,-32","w":200},"c":{"d":"16,-69v0,-83,71,-149,147,-113r-6,28v-52,-33,-106,20,-106,79v0,51,55,63,91,34r-4,34v-54,27,-122,5,-122,-62","w":165},"d":{"d":"14,-66v0,-69,42,-125,106,-125v18,0,31,7,40,22r18,-96r32,0r-46,265r-33,0r4,-22v-35,47,-121,25,-121,-44xm123,-163v-44,0,-73,43,-73,90v0,52,48,62,76,31v20,-22,22,-59,28,-94v-3,-12,-15,-27,-31,-27","w":200},"e":{"d":"187,-146v0,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-64,24,-123,4,-123,-72v0,-62,46,-115,108,-114v34,0,61,14,61,46xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51","w":193},"f":{"d":"158,-234v-36,-14,-52,3,-61,46r43,0r-3,23r-44,0r-29,177v-6,34,-33,55,-68,60r-3,-21v15,-2,32,-25,35,-39r31,-177r-27,0r4,-23r26,0v11,-60,48,-89,102,-72","w":144,"k":{"\u2019":7}},"g":{"d":"154,5v1,67,-111,90,-156,48r16,-25v39,24,97,25,107,-16v0,-35,-71,-10,-73,-45v0,-8,10,-15,30,-23v-33,3,-55,-23,-57,-52v-4,-65,74,-106,126,-71r16,-18r18,19r-17,18v17,45,-14,94,-50,105v-16,5,-25,11,-25,16v1,10,14,5,21,5v29,0,44,13,44,39xm134,-134v0,-17,-13,-32,-31,-31v-46,-7,-70,88,-19,91v26,2,50,-34,50,-60","w":180},"h":{"d":"77,-168v33,-42,122,-28,108,50r-21,118r-35,0r23,-131v2,-49,-64,-34,-79,-9r-25,140r-34,0r46,-265r33,0","w":200},"i":{"d":"55,-239v0,-12,12,-23,23,-23v12,0,24,10,24,23v0,12,-12,25,-24,23v-12,2,-23,-12,-23,-23xm24,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0","w":110},"j":{"d":"79,-239v0,-11,12,-23,23,-23v12,0,24,11,24,23v0,12,-12,25,-24,23v-12,2,-23,-12,-23,-23xm-24,73r1,-30v40,0,63,-14,69,-44r30,-159r-24,0r5,-28r58,0r-34,185v-10,54,-41,75,-105,76","w":132},"k":{"d":"78,-83r-14,11r-12,72r-33,0r44,-265r33,0r-24,154v44,-41,71,-69,81,-83r22,20v-19,21,-42,45,-71,73r71,101r-40,0","w":181},"l":{"d":"86,-21r-4,25v-66,-4,-62,-35,-48,-99r34,-170r35,0r-42,222v0,14,8,22,25,22","w":115},"m":{"d":"178,-167v27,-40,120,-35,107,41r-22,126r-35,0r23,-133v3,-45,-67,-35,-72,-6r-25,139r-34,0r24,-139v0,-38,-64,-25,-74,0r-25,139r-34,0r26,-154v0,-13,-2,-23,-4,-31r33,-7v2,9,3,18,3,25v17,-30,96,-36,109,0","w":298},"n":{"d":"128,0r22,-134v2,-46,-64,-29,-78,-6r-25,140r-33,0r26,-154v0,-12,-2,-22,-4,-31r33,-7v3,17,4,26,4,28v24,-39,119,-43,113,24v-4,49,-16,93,-23,140r-35,0","w":196},"o":{"d":"83,4v-45,0,-69,-28,-70,-73v-1,-64,43,-124,104,-123v45,1,72,25,71,71v-1,66,-37,124,-105,125xm113,-165v-44,2,-64,49,-65,94v0,32,13,47,40,47v42,0,66,-51,65,-95v0,-30,-13,-46,-40,-46","w":193},"p":{"d":"194,-121v6,81,-75,155,-148,112r-15,84r-34,0r40,-234v0,-9,-1,-18,-3,-26r34,-6v1,2,1,9,3,24v35,-42,133,-26,123,46xm158,-117v5,-52,-66,-57,-89,-24r-19,104v49,37,117,-14,108,-80","w":200},"q":{"d":"14,-67v0,-81,83,-161,152,-107r9,-14r27,0v-24,87,-33,172,-51,262r-33,0r15,-85v-43,36,-119,4,-119,-56xm50,-75v-6,49,55,63,87,38r20,-112v-45,-43,-115,15,-107,74","w":200},"r":{"d":"147,-155v-34,-27,-73,15,-79,47r-19,108r-34,0r34,-188r33,0r-5,30v21,-27,43,-40,79,-31","w":149,"k":{"\u2019":2,".":47,"-":26,",":47}},"s":{"d":"110,-99v53,33,3,103,-55,103v-20,0,-37,-5,-53,-15r17,-32v19,31,102,14,72,-26v-17,-22,-66,-25,-66,-65v0,-53,71,-74,120,-45r-15,31v-22,-31,-86,-13,-64,23v9,9,31,18,44,26","w":145},"t":{"d":"121,-2v-38,16,-99,3,-87,-53r22,-107r-21,0r5,-26r22,0r8,-40r38,-14r-13,54r52,0r-5,26r-52,0r-22,110v-2,30,32,31,55,21","w":151},"u":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0","w":200},"v":{"d":"81,4r-9,0r-55,-193r35,0r34,130r72,-130r38,0","w":176,"k":{".":44,",":44}},"w":{"d":"183,4r-9,0r-35,-123r-75,123r-9,0r-35,-193r34,0r21,120r70,-120r9,0r33,121r59,-121r35,0","w":267,"k":{".":41,",":41}},"x":{"d":"123,0r-33,-66r-52,66r-40,0r77,-98r-47,-90r39,0r31,65r48,-65r44,0r-75,93r52,95r-44,0","w":180},"y":{"d":"5,74r0,-34v42,0,57,-11,67,-39v-17,0,-28,-16,-33,-49r-24,-140r37,0r20,136v2,13,7,21,15,21r68,-157r37,0r-94,210v-17,37,-38,52,-93,52","w":177,"k":{".":42,",":42}},"z":{"d":"59,-30r94,0r-6,30r-146,0r0,-9r116,-149r-97,0r6,-30r147,0r0,9","w":170},"{":{"d":"45,19v0,27,20,31,54,30r-4,25v-43,3,-84,-7,-86,-44v-2,-34,66,-115,-3,-122r3,-15v44,-1,50,-51,41,-95v1,-48,49,-67,104,-62r-4,23v-40,-4,-70,5,-66,45v6,52,-7,79,-47,96v61,20,8,79,8,119","w":132},"|":{"d":"81,49r0,-296r26,0r0,296r-26,0"},"}":{"d":"79,-37v0,76,-22,120,-102,111r4,-25v66,6,66,-34,66,-91v0,-26,17,-46,49,-58v-21,-13,-32,-28,-32,-43v0,-15,26,-59,23,-75v2,-27,-29,-23,-55,-23r4,-23v44,-3,86,5,86,43v0,30,-60,107,4,114r-2,15v-30,2,-45,21,-45,55","w":132},"~":{"d":"124,-87v-30,0,-70,-40,-94,-7r-8,-4v3,-19,22,-39,44,-39v34,0,70,48,92,5r8,3v-5,20,-20,42,-42,42"},"\u00c4":{"d":"165,0r-9,-54r-92,0r-30,54r-40,0r151,-261r9,0r51,261r-40,0xm137,-190r-59,110r75,0xm89,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm172,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":219},"\u00c5":{"d":"165,0r-9,-54r-92,0r-30,54r-40,0r151,-261r9,0r51,261r-40,0xm137,-190r-59,110r75,0xm189,-307v0,20,-17,31,-39,31v-22,0,-39,-11,-39,-31v0,-39,78,-42,78,0xm174,-307v-2,-21,-46,-21,-47,0v0,11,7,16,23,16v12,1,24,-5,24,-16","w":219},"\u00c7":{"d":"25,-93v0,-104,77,-199,187,-161r-10,35v-73,-46,-140,46,-140,119v0,81,76,91,121,47r-3,38v-14,13,-37,19,-67,19v-57,0,-88,-39,-88,-97xm115,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":215},"\u00c9":{"d":"85,-226r-13,72r86,0r-6,30r-85,0r-16,92r117,0r-6,32r-154,0r46,-258r155,0r-5,32r-119,0xm171,-337r-40,59r-24,0r30,-59r34,0","w":192},"\u00d1":{"d":"176,4r-100,-183r-30,179r-36,0r46,-258r14,0r98,176r30,-176r35,0r-46,262r-11,0xm118,-315v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":229},"\u00d6":{"d":"105,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm149,-231v-53,0,-91,79,-90,132v0,39,16,71,52,72v62,0,96,-71,95,-137v0,-44,-19,-67,-57,-67xm94,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm177,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":242},"\u00dc":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61xm84,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm167,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":233},"\u00e1":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115xm177,-274r-40,59r-24,0r30,-59r34,0","w":189},"\u00e0":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115xm115,-215r-27,-59r34,0r11,59r-18,0","w":189},"\u00e2":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115xm152,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":189},"\u00e4":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115xm67,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm150,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":189},"\u00e3":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115xm111,-252v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":189},"\u00e5":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115xm174,-246v0,20,-17,31,-39,31v-22,0,-39,-11,-39,-31v0,-39,78,-42,78,0xm159,-246v-2,-21,-46,-21,-47,0v0,11,7,16,23,16v12,1,24,-5,24,-16","w":189},"\u00e7":{"d":"16,-69v0,-83,71,-149,147,-113r-6,28v-52,-33,-106,20,-106,79v0,51,55,63,91,34r-4,34v-54,27,-122,5,-122,-62xm88,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":165},"\u00e9":{"d":"187,-146v0,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-64,24,-123,4,-123,-72v0,-62,46,-115,108,-114v34,0,61,14,61,46xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51xm173,-274r-40,59r-24,0r30,-59r34,0","w":193},"\u00e8":{"d":"187,-146v0,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-64,24,-123,4,-123,-72v0,-62,46,-115,108,-114v34,0,61,14,61,46xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51xm123,-215r-27,-59r34,0r11,59r-18,0","w":193},"\u00ea":{"d":"187,-146v0,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-64,24,-123,4,-123,-72v0,-62,46,-115,108,-114v34,0,61,14,61,46xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51xm151,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":193},"\u00eb":{"d":"187,-146v0,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-64,24,-123,4,-123,-72v0,-62,46,-115,108,-114v34,0,61,14,61,46xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51xm66,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm149,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":193},"\u00ed":{"d":"24,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0xm108,-274r-40,59r-24,0r30,-59r34,0","w":110},"\u00ec":{"d":"24,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0xm63,-215r-27,-59r34,0r11,59r-18,0","w":110},"\u00ee":{"d":"42,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0xm114,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":110},"\u00ef":{"d":"24,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0xm24,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm107,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":110},"\u00f1":{"d":"128,0r22,-134v2,-46,-64,-29,-78,-6r-25,140r-33,0r26,-154v0,-12,-2,-22,-4,-31r33,-7v3,17,4,26,4,28v24,-39,119,-43,113,24v-4,49,-16,93,-23,140r-35,0xm104,-252v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":196},"\u00f3":{"d":"83,4v-45,0,-69,-28,-70,-73v-1,-64,43,-124,104,-123v45,1,72,25,71,71v-1,66,-37,124,-105,125xm113,-165v-44,2,-64,49,-65,94v0,32,13,47,40,47v42,0,66,-51,65,-95v0,-30,-13,-46,-40,-46xm161,-274r-40,59r-24,0r30,-59r34,0","w":193},"\u00f2":{"d":"83,4v-45,0,-69,-28,-70,-73v-1,-64,43,-124,104,-123v45,1,72,25,71,71v-1,66,-37,124,-105,125xm113,-165v-44,2,-64,49,-65,94v0,32,13,47,40,47v42,0,66,-51,65,-95v0,-30,-13,-46,-40,-46xm116,-215r-27,-59r34,0r11,59r-18,0","w":193},"\u00f4":{"d":"83,4v-45,0,-69,-28,-70,-73v-1,-64,43,-124,104,-123v45,1,72,25,71,71v-1,66,-37,124,-105,125xm113,-165v-44,2,-64,49,-65,94v0,32,13,47,40,47v42,0,66,-51,65,-95v0,-30,-13,-46,-40,-46xm142,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":193},"\u00f6":{"d":"83,4v-45,0,-69,-28,-70,-73v-1,-64,43,-124,104,-123v45,1,72,25,71,71v-1,66,-37,124,-105,125xm113,-165v-44,2,-64,49,-65,94v0,32,13,47,40,47v42,0,66,-51,65,-95v0,-30,-13,-46,-40,-46xm62,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm145,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":193},"\u00f5":{"d":"83,4v-45,0,-69,-28,-70,-73v-1,-64,43,-124,104,-123v45,1,72,25,71,71v-1,66,-37,124,-105,125xm113,-165v-44,2,-64,49,-65,94v0,32,13,47,40,47v42,0,66,-51,65,-95v0,-30,-13,-46,-40,-46xm100,-252v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":193},"\u00fa":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0xm165,-274r-40,59r-24,0r30,-59r34,0","w":200},"\u00f9":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0xm120,-215r-27,-59r34,0r11,59r-18,0","w":200},"\u00fb":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0xm151,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":200},"\u00fc":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0xm66,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm149,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":200},"\u2020":{"d":"85,-164r-65,0r4,-24r65,0r10,-55r26,0r-10,55r65,0r-4,24r-65,0r-37,208r-15,15r-11,-15","w":165},"\u00b0":{"d":"152,-225v0,20,-17,37,-37,37v-20,0,-37,-16,-37,-37v0,-21,17,-37,37,-37v20,0,37,17,37,37xm139,-225v0,-13,-11,-25,-24,-25v-14,0,-25,11,-25,25v0,13,12,24,25,24v13,0,24,-11,24,-24"},"\u00a2":{"d":"31,-75v0,-53,34,-94,85,-94r14,-45r17,0r-13,47v11,3,20,8,28,14r-7,25v-8,-7,-18,-13,-28,-16r-29,103v16,3,33,-4,48,-12r-4,27v-15,6,-30,8,-50,8r-13,45r-21,0r15,-49v-18,-2,-42,-32,-42,-53xm109,-144v-39,0,-64,73,-29,98"},"\u00a3":{"d":"14,-21v25,-11,48,-59,45,-101r-31,0r4,-26r27,0v-6,-85,39,-125,115,-108v8,2,13,6,16,10r-16,26v-45,-30,-87,2,-80,72r37,0r-4,26r-33,0v1,26,-9,84,-25,93v26,19,81,15,94,-12r21,23v-7,15,-44,33,-67,33v-36,0,-59,-20,-98,-9","w":190},"\u00a7":{"d":"29,-126v0,-15,12,-36,23,-39v-10,-6,-14,-16,-14,-31v0,-63,83,-84,127,-49r-15,27v-17,-26,-106,-4,-65,29v19,15,68,14,68,51v0,16,-7,31,-21,43v45,40,-12,99,-66,99v-26,0,-46,-5,-59,-16r16,-31v20,19,89,27,87,-16v-1,-32,-81,-24,-81,-67xm77,-155v-31,24,-4,44,34,47v12,-14,8,-38,-10,-40v-5,-1,-13,-4,-24,-7","w":163},"\u2022":{"d":"44,-101v0,-27,24,-51,51,-51v27,0,51,24,51,51v0,27,-24,51,-51,51v-27,0,-51,-24,-51,-51"},"\u00b6":{"d":"121,-29v-47,2,-92,-38,-92,-88v0,-72,63,-116,133,-122r2,-19r31,0r-2,16v11,-1,18,-1,24,-1r0,23r-27,0r-31,167v7,0,16,-3,28,-7r4,24v-13,5,-26,8,-37,8v-14,54,-22,94,-69,94v-26,0,-43,-4,-51,-12r10,-27v41,21,68,6,77,-56xm158,-214v-57,11,-97,128,-30,157","w":215},"\u00df":{"d":"111,-159v6,-22,36,-27,36,-57v0,-23,-37,-25,-50,-9v-6,8,-12,23,-16,46r-35,199v-6,28,-35,49,-66,52r-2,-21v21,-6,33,-22,38,-50r36,-205v9,-35,29,-60,70,-61v32,0,55,11,57,39v2,27,-24,47,-32,62v16,14,43,33,43,67v0,60,-46,118,-107,96r11,-26v37,10,59,-26,60,-61v1,-37,-35,-39,-43,-71","w":196},"\u00ae":{"d":"137,2v-65,0,-119,-54,-119,-118v0,-64,55,-119,119,-119v64,0,119,55,119,119v0,64,-54,118,-119,118xm137,-17v53,0,99,-46,99,-99v0,-53,-46,-99,-99,-99v-53,0,-99,46,-99,99v0,53,46,99,99,99xm174,-45r-37,-62r-21,0r0,62r-21,0r0,-146v44,-2,90,0,90,41v0,19,-9,31,-28,39r40,66r-23,0xm116,-124v27,-1,48,3,48,-25v0,-21,-22,-26,-48,-24r0,49","w":256},"\u00a9":{"d":"137,2v-65,0,-119,-54,-119,-118v0,-64,55,-119,119,-119v64,0,119,55,119,119v0,64,-54,118,-119,118xm137,-17v53,0,99,-46,99,-99v0,-53,-46,-99,-99,-99v-53,0,-99,46,-99,99v0,53,46,99,99,99xm97,-115v-6,45,47,73,74,41r11,15v-41,42,-106,5,-106,-58v0,-55,50,-92,100,-68r-6,17v-35,-22,-79,9,-73,53","w":256},"\u2122":{"d":"88,-243r0,113r-18,0r0,-113r-36,0r0,-16r92,0r0,16r-38,0xm220,-130r-14,-87r-26,88r-10,0r-28,-90r-13,89r-17,0r20,-129r13,0r30,100r29,-100r13,0r20,129r-17,0","w":228},"\u00b4":{"d":"161,-274r-40,59r-24,0r30,-59r34,0"},"\u00a8":{"d":"66,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm149,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20"},"\u2260":{"d":"147,-185r24,0r-25,31r25,0r0,25r-45,0r-28,35r73,0r0,25r-94,0r-29,35r-24,0r29,-35r-29,0r0,-25r49,0r29,-35r-78,0r0,-25r98,0"},"\u00c6":{"d":"137,-54r-77,0r-33,54r-42,0r170,-258r172,0r-6,32r-117,0r-12,72r83,0r-5,30r-83,0r-17,92r115,0r-5,32r-152,0xm167,-220r-91,140r66,0","w":312},"\u00d8":{"d":"35,-37v-55,-116,63,-285,182,-204r18,-21r35,0r-37,42v36,102,-21,224,-128,224v-21,0,-38,-5,-52,-18r-16,18r-37,0xm63,-69r129,-145v-76,-61,-152,61,-129,145xm77,-42v75,52,145,-54,127,-145","w":242},"\u221e":{"d":"190,-118v0,46,-64,52,-85,13v-22,39,-86,33,-86,-13v0,-44,64,-50,85,-15v21,-34,86,-30,86,15xm115,-118v10,14,22,20,34,20v15,0,23,-6,23,-20v0,-30,-41,-24,-57,0xm94,-118v-12,-13,-22,-20,-31,-20v-16,0,-25,6,-25,20v0,31,44,23,56,0"},"\u00b1":{"d":"112,-124r62,0r0,25r-62,0r0,60r-24,0r0,-60r-61,0r0,-25r61,0r0,-60r24,0r0,60xm174,-21r0,25r-147,0r0,-25r147,0"},"\u2264":{"d":"26,-104r0,-22r130,-62r0,28r-100,45r100,45r0,29xm169,-21r0,25r-148,0r0,-25r148,0"},"\u2265":{"d":"169,-104r-130,63r0,-29r100,-45r-100,-45r0,-28r130,62r0,22xm27,-21r147,0r0,25r-147,0r0,-25"},"\u00a5":{"d":"126,-115r-4,19r44,0r-4,23r-44,0r-13,73r-35,0r13,-73r-43,0r4,-23r43,0r3,-19r-58,-143r37,0r43,110r82,-110r39,0","w":200},"\u03bc":{"d":"127,-26v-12,25,-57,39,-87,23r-13,77r-34,0r47,-262r33,0r-21,128v-4,38,46,42,66,23v8,-8,13,-13,14,-15r24,-136r33,0r-33,188r-33,0","w":200},"\u2202":{"d":"14,-58v0,-71,51,-129,119,-129v-16,-31,-36,-46,-76,-58r14,-28v65,9,120,74,120,146v0,72,-41,131,-111,131v-40,0,-66,-23,-66,-62xm83,-26v57,0,91,-86,63,-136v-51,-3,-98,45,-98,96v0,21,15,40,35,40","w":197},"\u2211":{"d":"88,-226r53,96r-93,129r113,0r0,31r-157,0r0,-31r95,-129r-53,-99r0,-29r153,0r0,32r-111,0"},"\u220f":{"d":"94,-226r-45,256r-35,0r45,-256r-37,0r5,-32r208,0r-6,32r-31,0r-45,256r-36,0r45,-256r-68,0","w":198},"\u03c0":{"d":"202,-28r-4,28v-38,14,-71,-6,-63,-52r18,-108r-60,0r-28,160r-34,0r28,-160r-29,0r5,-28r184,0r-5,28r-27,0r-20,120v-1,19,22,21,35,12","w":216},"\u222b":{"d":"-31,55r20,-28v12,19,38,25,52,4v7,-9,11,-18,13,-29r33,-189v3,-59,78,-104,127,-61r-19,26v-30,-27,-60,-15,-70,40v-14,78,-14,181,-57,235v-23,29,-74,28,-99,2"},"\u00aa":{"d":"39,-170v-6,-63,67,-117,124,-81v-5,39,-31,89,-6,124r-23,0v-5,-5,-9,-9,-10,-14v-23,29,-91,18,-85,-29xm138,-236v-36,-20,-71,24,-71,64v0,17,7,26,23,26v32,0,41,-58,48,-90","w":162},"\u00ba":{"d":"97,-126v-32,0,-52,-19,-53,-50v0,-49,27,-86,76,-86v32,0,51,19,51,50v0,49,-26,86,-74,86xm116,-243v-31,0,-45,31,-45,65v0,18,12,34,30,33v29,0,44,-34,43,-66v0,-21,-9,-32,-28,-32","w":165},"\u03a9":{"d":"244,-167v0,64,-31,116,-73,141r51,0r-5,26r-89,0r4,-27v46,-37,75,-67,75,-136v0,-45,-20,-67,-59,-67v-91,0,-112,153,-53,204r-4,26r-88,0r4,-26r47,0v-69,-78,-15,-236,100,-236v60,0,90,32,90,95","w":240},"\u00e6":{"d":"301,-146v1,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-40,14,-73,16,-97,-12v0,7,0,13,-1,18r-33,0v0,-5,1,-14,3,-27v-8,17,-33,31,-57,31v-39,-1,-59,-24,-59,-64v0,-64,44,-132,109,-132v24,0,45,2,60,7r-2,13v35,-29,122,-31,123,26xm146,-159v-62,-26,-101,37,-100,98v0,25,11,37,32,37v45,0,61,-84,68,-135xm174,-113v33,13,93,5,94,-31v1,-24,-57,-27,-70,-5v-10,10,-19,22,-24,36","w":304},"\u00f8":{"d":"22,-29v-41,-89,53,-206,144,-148r14,-15r29,0r-30,32v39,89,-52,206,-143,149r-14,15r-32,0xm142,-153v-51,-39,-105,32,-93,96xm59,-35v54,38,104,-33,93,-97","w":193},"\u00bf":{"d":"116,-167v0,13,-11,25,-25,25v-14,0,-25,-11,-25,-25v0,-14,12,-25,25,-25v13,0,25,12,25,25xm98,-113v19,68,-66,78,-70,136v-2,31,47,28,63,13r11,23v-28,25,-108,22,-108,-35v0,-69,84,-76,87,-137r17,0","w":132},"\u00a1":{"d":"110,-167v0,13,-11,25,-25,25v-14,0,-25,-11,-25,-25v0,-14,11,-25,25,-25v14,0,25,12,25,25xm84,-121v0,94,-8,124,-21,195r-40,0v14,-80,16,-98,48,-195r13,0","w":132},"\u00ac":{"d":"169,-156r0,86r-25,0r0,-61r-123,0r0,-25r148,0"},"\u221a":{"d":"132,-237r-67,237r-25,0r-37,-47r17,-15r26,34r66,-231r79,0r0,22r-59,0"},"\u0192":{"d":"158,-234v-36,-14,-52,3,-61,46r43,0r-3,23r-44,0r-29,177v-6,34,-33,55,-68,60r-3,-21v15,-2,32,-25,35,-39r31,-177r-27,0r4,-23r26,0v11,-60,48,-89,102,-72","w":144},"\u2248":{"d":"145,-105v-31,0,-69,-41,-94,-7r-7,-3v3,-20,21,-40,43,-40v33,-1,70,47,92,5r9,3v-5,20,-21,42,-43,42xm122,-40v-31,-1,-69,-41,-94,-7r-7,-3v3,-20,21,-40,43,-40v33,0,70,47,92,5r9,3v-4,21,-20,42,-43,42"},"\u0394":{"d":"4,0r4,-22r134,-236r25,0r43,236r-4,22r-202,0xm144,-197r-93,167r119,0","w":210},"\u00ab":{"d":"22,-94r2,-11r70,-43r-4,22r-42,27r33,25r-4,22xm94,-94r2,-11r70,-43r-4,22r-42,27r33,25r-4,22"},"\u00bb":{"d":"99,-94r-69,42r4,-22r41,-25r-32,-27r4,-22r54,43xm170,-94r-69,42r4,-22r41,-25r-32,-27r4,-22r54,43"},"\u2026":{"d":"44,-49v14,0,26,11,26,26v0,15,-12,27,-26,27v-14,0,-26,-12,-26,-27v0,-14,11,-26,26,-26xm132,-49v15,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27v0,-14,12,-26,26,-26xm220,-49v15,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27v0,-14,12,-26,26,-26","w":264},"\u00a0":{"w":108},"\u00c0":{"d":"165,0r-9,-54r-92,0r-30,54r-40,0r151,-261r9,0r51,261r-40,0xm137,-190r-59,110r75,0xm142,-278r-27,-59r34,0r11,59r-18,0","w":219},"\u00c3":{"d":"165,0r-9,-54r-92,0r-30,54r-40,0r151,-261r9,0r51,261r-40,0xm137,-190r-59,110r75,0xm130,-315v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":219},"\u00d5":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-53,0,-91,79,-90,132v0,39,16,71,52,72v62,0,96,-71,95,-137v0,-44,-19,-67,-57,-67xm144,-315v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":242},"\u0152":{"d":"9,-95v0,-89,49,-166,130,-167v32,0,56,9,71,27r4,-23r154,0r-6,32r-119,0r-12,72r85,0r-5,30r-85,0r-17,92r117,0r-6,32r-152,0r5,-24v-18,19,-45,28,-81,28v-54,0,-83,-43,-83,-99xm133,-230v-54,0,-87,71,-87,131v0,36,18,72,52,72v64,-1,96,-65,95,-137v0,-44,-20,-66,-60,-66","w":357},"\u0153":{"d":"182,-89v-14,59,49,82,90,49r-4,34v-45,17,-96,13,-113,-25v-38,55,-145,47,-145,-38v0,-63,43,-125,104,-123v30,0,52,11,63,33v20,-22,45,-33,76,-33v35,0,61,14,62,46v2,58,-82,82,-133,57xm85,-24v43,1,66,-51,65,-95v0,-30,-13,-46,-40,-46v-41,-1,-66,51,-65,94v0,32,13,47,40,47xm188,-113v33,14,92,4,94,-31v1,-24,-57,-27,-71,-5v-10,10,-18,21,-23,36","w":320},"\u2013":{"d":"15,-94r4,-23r92,0r-4,23r-92,0","w":132},"\u2014":{"d":"15,-94r4,-23r230,0r-4,23r-230,0","w":264},"\u201c":{"d":"176,-239v-23,16,0,37,3,55v-2,17,-11,26,-28,26v-19,0,-25,-11,-24,-31v3,-31,20,-56,53,-76r10,15xm96,-239v-24,16,-2,37,2,55v-2,17,-10,26,-27,26v-19,0,-26,-11,-25,-31v3,-31,20,-56,53,-76r11,15"},"\u201d":{"d":"140,-185v23,-16,0,-37,-3,-55v1,-17,11,-25,28,-25v19,0,25,11,24,31v-3,31,-20,56,-53,76r-10,-16xm59,-185v23,-16,0,-37,-3,-55v1,-17,11,-25,28,-25v19,-1,27,12,24,31v-4,31,-20,56,-53,76r-10,-16"},"\u2018":{"d":"106,-239v-24,16,-2,37,2,55v-2,17,-10,26,-27,26v-19,0,-26,-11,-25,-31v3,-31,20,-56,53,-76r11,15","w":132,"k":{"\u2018":35}},"\u2019":{"d":"68,-185v23,-16,0,-37,-3,-55v1,-17,10,-25,27,-25v19,0,26,11,25,31v-3,31,-20,56,-53,76r-11,-16","w":132,"k":{"\u2019":35,"t":31,"s":25," ":20}},"\u00f7":{"d":"102,-202v14,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27v0,-13,13,-26,26,-26xm175,-124r0,25r-147,0r0,-25r147,0xm102,-70v15,0,27,12,27,26v0,14,-13,27,-27,27v-14,0,-26,-13,-26,-27v0,-14,12,-26,26,-26"},"\u25ca":{"d":"97,-250r73,125r-73,125r-20,0r-69,-125r69,-125r20,0xm87,-233r-60,108r60,108r63,-108","w":177},"\u00ff":{"d":"5,74r0,-34v42,0,57,-11,67,-39v-17,0,-28,-16,-33,-49r-24,-140r37,0r20,136v2,13,7,21,15,21r68,-157r37,0r-94,210v-17,37,-38,52,-93,52xm59,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm142,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":177},"\u0178":{"d":"126,-115r-21,115r-35,0r20,-115r-58,-143r37,0r43,110r82,-110r39,0xm75,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm158,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":205},"\u2044":{"d":"23,6r-22,0r171,-268r22,0","w":190},"\u2215":{"d":"23,6r-22,0r171,-268r22,0","w":190},"\u20ac":{"d":"49,-165v13,-67,87,-117,160,-81r-17,30v-43,-33,-96,12,-103,51r75,0r-7,27r-76,0v-2,7,-3,14,-4,21r73,0r-7,26r-67,0v-3,71,64,81,100,38r0,37v-13,13,-32,20,-58,20v-53,1,-80,-41,-80,-95r-22,0r0,-26r24,0r3,-21r-27,0r0,-27r33,0"},"\u2039":{"d":"29,-94r2,-11r70,-43r-4,22r-42,27r33,25r-4,22","w":132},"\u203a":{"d":"98,-94r-69,42r4,-22r41,-25r-32,-27r4,-22r54,43","w":132},"\uf001":{"d":"147,0r28,-165r-82,0r-29,177v-6,34,-33,55,-68,60r-3,-21v15,-2,32,-25,35,-39r31,-177r-27,0r4,-23r26,0v11,-60,48,-89,102,-72r-6,26v-36,-14,-52,3,-61,46r116,0r-32,188r-34,0xm177,-239v0,-13,12,-23,24,-23v11,0,23,11,23,23v0,11,-11,25,-23,23v-12,2,-24,-11,-24,-23","w":229},"\ufb01":{"d":"147,0r28,-165r-82,0r-29,177v-6,34,-33,55,-68,60r-3,-21v15,-2,32,-25,35,-39r31,-177r-27,0r4,-23r26,0v11,-60,48,-89,102,-72r-6,26v-36,-14,-52,3,-61,46r116,0r-32,188r-34,0xm177,-239v0,-13,12,-23,24,-23v11,0,23,11,23,23v0,11,-11,25,-23,23v-12,2,-24,-11,-24,-23","w":229},"\uf002":{"d":"62,-188v2,-64,80,-99,128,-60r2,-17r36,0r-43,214v0,21,6,29,25,30r-4,25v-66,-4,-59,-35,-47,-99r24,-124v-12,-19,-53,-29,-70,-6v-7,10,-13,21,-16,37r43,0r-3,23r-44,0r-29,177v-6,34,-33,55,-68,60r-3,-21v15,-2,32,-25,35,-39r31,-177r-27,0r4,-23r26,0","w":242},"\ufb02":{"d":"62,-188v2,-64,80,-99,128,-60r2,-17r36,0r-43,214v0,21,6,29,25,30r-4,25v-66,-4,-59,-35,-47,-99r24,-124v-12,-19,-53,-29,-70,-6v-7,10,-13,21,-16,37r43,0r-3,23r-44,0r-29,177v-6,34,-33,55,-68,60r-3,-21v15,-2,32,-25,35,-39r31,-177r-27,0r4,-23r26,0","w":242},"\u2021":{"d":"156,-67r-4,25r-65,0r-15,86r-16,16r-10,-16r15,-86r-65,0r4,-25r65,0r17,-97r-65,0r4,-24r65,0r10,-55r27,0r-10,55r65,0r-5,24r-65,0r-17,97r65,0","w":165},"\u2219":{"d":"36,-114v0,-14,12,-27,26,-27v14,0,27,13,27,27v0,14,-13,26,-27,26v-13,0,-26,-13,-26,-26","w":132},"\u201a":{"d":"35,31v24,-15,2,-36,-2,-54v1,-17,10,-26,27,-26v19,0,26,11,25,31v-3,31,-21,56,-54,76r-10,-15","w":132},"\u201e":{"d":"107,31v24,-15,2,-36,-2,-54v2,-17,10,-26,27,-26v19,0,26,11,25,31v-3,31,-20,56,-53,76r-11,-15xm27,31v23,-16,0,-36,-3,-54v2,-17,11,-26,28,-26v19,0,25,11,24,31v-3,31,-20,56,-53,76r-11,-15"},"\u2030":{"d":"27,4r-22,0r202,-266r22,0xm135,-219v1,39,-25,79,-61,78v-26,0,-40,-15,-40,-43v0,-39,24,-78,63,-78v25,0,38,17,38,43xm75,-159v26,0,38,-31,38,-60v0,-17,-7,-25,-20,-25v-23,-1,-37,32,-37,57v0,19,6,28,19,28xm204,-74v1,39,-25,79,-61,78v-26,0,-40,-15,-40,-43v0,-39,24,-78,63,-78v25,0,38,17,38,43xm145,-14v25,1,38,-30,37,-60v0,-17,-7,-25,-20,-25v-23,-2,-37,32,-36,57v0,19,6,28,19,28xm319,-74v0,39,-26,79,-62,78v-26,0,-39,-15,-39,-43v-1,-40,24,-78,62,-78v26,0,38,18,39,43xm259,-14v26,0,38,-31,38,-60v0,-17,-7,-25,-20,-25v-23,-2,-37,31,-37,57v0,19,6,28,19,28","w":328},"\u00c2":{"d":"165,0r-9,-54r-92,0r-30,54r-40,0r151,-261r9,0r51,261r-40,0xm137,-190r-59,110r75,0xm175,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":219},"\u00ca":{"d":"85,-226r-13,72r86,0r-6,30r-85,0r-16,92r117,0r-6,32r-154,0r46,-258r155,0r-5,32r-119,0xm161,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":192},"\u00c1":{"d":"165,0r-9,-54r-92,0r-30,54r-40,0r151,-261r9,0r51,261r-40,0xm137,-190r-59,110r75,0xm186,-337r-40,59r-24,0r30,-59r34,0","w":219},"\u00cb":{"d":"85,-226r-13,72r86,0r-6,30r-85,0r-16,92r117,0r-6,32r-154,0r46,-258r155,0r-5,32r-119,0xm78,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm161,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":192},"\u00c8":{"d":"85,-226r-13,72r86,0r-6,30r-85,0r-16,92r117,0r-6,32r-154,0r46,-258r155,0r-5,32r-119,0xm136,-278r-27,-59r34,0r11,59r-18,0","w":192},"\u00cd":{"d":"13,0r46,-258r36,0r-46,258r-36,0xm132,-337r-40,59r-24,0r30,-59r34,0","w":100},"\u00ce":{"d":"13,0r46,-258r36,0r-46,258r-36,0xm108,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":100},"\u00cf":{"d":"13,0r46,-258r36,0r-46,258r-36,0xm20,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm103,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":100},"\u00cc":{"d":"13,0r46,-258r36,0r-46,258r-36,0xm76,-278r-27,-59r34,0r11,59r-18,0","w":100},"\u00d3":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-53,0,-91,79,-90,132v0,39,16,71,52,72v62,0,96,-71,95,-137v0,-44,-19,-67,-57,-67xm201,-337r-40,59r-24,0r30,-59r34,0","w":242},"\u00d4":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-53,0,-91,79,-90,132v0,39,16,71,52,72v62,0,96,-71,95,-137v0,-44,-19,-67,-57,-67xm187,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":242},"\uf000":{"d":"22,-62r0,-135r136,0r0,135r-136,0xm45,-84r90,0r0,-90r-90,0r0,90","w":180},"\u00d2":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-53,0,-91,79,-90,132v0,39,16,71,52,72v62,0,96,-71,95,-137v0,-44,-19,-67,-57,-67xm162,-278r-27,-59r34,0r11,59r-18,0","w":242},"\u00da":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61xm196,-337r-40,59r-24,0r30,-59r34,0","w":233},"\u00db":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61xm179,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":233},"\u00d9":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61xm149,-278r-27,-59r34,0r11,59r-18,0","w":233},"\u0131":{"d":"24,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0","w":110},"\u02c6":{"d":"142,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0"},"\u02dc":{"d":"102,-252v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37"},"\u02c9":{"d":"183,-240r-4,25r-130,0r4,-25r130,0"},"\u02d8":{"d":"191,-272v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0"},"\u02d9":{"d":"109,-236v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21"},"\u02da":{"d":"157,-246v0,20,-17,31,-39,31v-22,0,-39,-11,-39,-31v0,-39,78,-42,78,0xm142,-246v-2,-21,-46,-21,-47,0v0,11,7,16,23,16v12,1,24,-5,24,-16"},"\u00b8":{"d":"78,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10"},"\u02dd":{"d":"128,-265r-35,50r-25,0r25,-50r35,0xm193,-265r-35,50r-25,0r25,-50r35,0"},"\u02db":{"d":"133,59v-32,15,-71,5,-71,-29v0,-24,16,-43,46,-58r5,28v-14,7,-22,15,-22,26v1,20,28,15,42,7r0,26"},"\u02c7":{"d":"188,-275r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0"},"\u0141":{"d":"9,-136r32,-12r19,-110r36,0r-17,96r27,-10r0,23r-31,11r-19,106r117,0r-6,32r-152,0r22,-124r-28,10r0,-22","w":182},"\u0142":{"d":"58,-51v0,21,6,29,25,30r-4,25v-86,2,-49,-74,-40,-136r-27,12r0,-20r31,-14r23,-111r35,0r-19,94r24,-12r0,21r-29,13","w":106},"\u0160":{"d":"148,-107v43,77,-49,142,-133,99r11,-34v26,20,102,23,98,-24v-5,-55,-87,-58,-87,-122v0,-67,79,-87,132,-67r-10,34v-31,-25,-108,-7,-83,44v13,24,58,44,72,70xm183,-328r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":173},"\u0161":{"d":"110,-99v53,33,3,103,-55,103v-20,0,-37,-5,-53,-15r17,-32v19,31,102,14,72,-26v-17,-22,-66,-25,-66,-65v0,-53,71,-74,120,-45r-15,31v-22,-31,-86,-13,-64,23v9,9,31,18,44,26xm175,-275r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":145},"\u017d":{"d":"14,0r0,-9r144,-217r-109,0r5,-32r154,0r0,9r-139,217r108,0r-5,32r-158,0xm200,-328r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":198},"\u017e":{"d":"59,-30r94,0r-6,30r-146,0r0,-9r116,-149r-97,0r6,-30r147,0r0,9xm185,-275r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":170},"\u00a6":{"d":"88,-122r0,-127r26,0r0,127r-26,0xm88,49r0,-128r26,0r0,128r-26,0"},"\u00d0":{"d":"219,-158v0,95,-61,159,-151,158r-56,0r22,-124r-28,0r5,-28r27,0r19,-106v85,-16,162,14,162,100xm181,-160v0,-48,-44,-81,-95,-67r-12,75r40,0r-4,28r-41,0r-15,91v82,11,127,-51,127,-127","w":220},"\u00f0":{"d":"11,-69v-2,-76,54,-141,131,-118v-4,-10,-9,-21,-16,-34r-31,16r-8,-15r31,-15v-3,-5,-11,-15,-24,-31r36,-6r18,23r30,-16r9,13r-31,17v53,76,40,243,-75,239v-45,-2,-69,-28,-70,-73xm112,-162v-43,-1,-68,47,-68,91v0,30,14,45,42,45v42,0,66,-47,65,-91v0,-30,-13,-45,-39,-45","w":197},"\u00dd":{"d":"126,-115r-21,115r-35,0r20,-115r-58,-143r37,0r43,110r82,-110r39,0xm178,-327r-40,59r-24,0r30,-59r34,0","w":205},"\u00de":{"d":"84,-224v59,-13,113,14,113,70v0,82,-60,115,-143,99r-10,55r-35,0r45,-258r35,0xm59,-87v51,19,100,-7,100,-62v0,-43,-40,-54,-81,-43","w":195},"\u00fe":{"d":"194,-121v6,81,-75,155,-148,112r-15,84r-34,0r58,-340r35,0r-18,98v34,-42,133,-27,122,46xm50,-37v49,37,117,-14,108,-80v6,-53,-66,-57,-89,-24","w":200},"\u2212":{"d":"169,-124r0,25r-148,0r0,-25r148,0"},"\u00b9":{"d":"73,-105r22,-118r-37,20r4,-20v25,-12,44,-24,56,-37r6,0r-27,155r-24,0","w":162},"\u00b2":{"d":"60,-232v8,-32,89,-45,88,1v-2,37,-47,78,-67,106r59,0r-4,20r-95,0v21,-40,74,-75,83,-121v-5,-28,-41,-17,-52,6","w":162},"\u00b3":{"d":"130,-156v0,46,-62,70,-94,41r14,-18v16,18,57,9,57,-22v0,-15,-9,-23,-27,-23v2,-5,1,-13,4,-17v28,5,48,-47,9,-46v-10,0,-18,3,-23,8r-6,-16v19,-22,74,-16,74,19v0,19,-16,38,-30,43v15,5,22,15,22,31","w":162},"\u00bd":{"d":"52,-105r22,-118r-37,20r4,-20v25,-12,44,-24,56,-37r6,0r-27,155r-24,0xm69,6r-22,0r171,-268r22,0xm184,-127v8,-32,89,-45,88,1v-2,37,-47,78,-67,106r59,0r-4,20r-95,0v21,-40,74,-75,83,-121v-5,-28,-41,-17,-52,6","w":293},"\u00bc":{"d":"248,-37r-6,37r-23,0r6,-37r-71,0r2,-12r106,-106r7,0r-18,100r16,0r-3,18r-16,0xm239,-109r-55,54r45,0xm49,-105r22,-118r-37,20r4,-20v25,-12,44,-24,56,-37r6,0r-27,155r-24,0xm66,6r-22,0r171,-268r22,0","w":293},"\u00be":{"d":"259,-37r-6,37r-23,0r7,-37r-71,0r2,-12r105,-106r7,0r-17,100r15,0r-3,18r-16,0xm250,-109r-55,54r45,0xm118,-156v0,46,-62,70,-94,41r14,-18v16,18,57,9,57,-22v0,-15,-9,-23,-27,-23v2,-5,1,-13,4,-17v28,5,48,-47,9,-46v-10,0,-18,3,-23,8r-6,-16v19,-22,74,-16,74,19v0,19,-16,38,-30,43v15,5,22,15,22,31xm91,6r-22,0r171,-268r22,0","w":293},"\u00b5":{"d":"127,-26v-12,25,-57,39,-87,23r-13,77r-34,0r47,-262r33,0r-21,128v-4,38,46,42,66,23v8,-8,13,-13,14,-15r24,-136r33,0r-33,188r-33,0","w":200},"\u2126":{"d":"244,-167v0,64,-31,116,-73,141r51,0r-5,26r-89,0r4,-27v46,-37,75,-67,75,-136v0,-45,-20,-67,-59,-67v-91,0,-112,153,-53,204r-4,26r-88,0r4,-26r47,0v-69,-78,-15,-236,100,-236v60,0,90,32,90,95","w":240},"\u2206":{"d":"-5,0r4,-22r134,-236r25,0r43,236r-4,22r-202,0xm135,-197r-93,167r119,0","w":210},"\u00fd":{"d":"5,74r0,-34v42,0,57,-11,67,-39v-17,0,-28,-16,-33,-49r-24,-140r37,0r20,136v2,13,7,21,15,21r68,-157r37,0r-94,210v-17,37,-38,52,-93,52xm157,-274r-40,59r-24,0r30,-59r34,0","w":177},"\u00d7":{"d":"96,-128r55,-56r18,18r-56,55r55,56r-17,17r-55,-55r-56,56r-18,-18r56,-55r-56,-57r17,-17"},"\u00ad":{"d":"25,-89r6,-31r75,0r-5,31r-76,0","w":132},"\uf006":{"d":"-24,73r1,-30v40,0,63,-14,69,-44r30,-159r-24,0r5,-28r58,0r-34,185v-10,54,-41,75,-105,76","w":132},"\uf007":{"d":"68,-260v-1,11,15,16,15,27v0,11,-7,18,-19,18v-13,0,-19,-9,-19,-26v0,-20,9,-36,27,-50r10,10v-9,10,-13,10,-14,21","w":132},"\u20a3":{"d":"86,-226r-12,72r90,0r-5,30r-90,0r-22,124r-37,0r46,-258r160,0r-6,32r-124,0xm336,-155v-34,-27,-73,15,-79,47r-19,108r-34,0r34,-188r33,0r-5,30v21,-27,43,-40,79,-31","w":338},"\u011e":{"d":"20,-95v0,-94,61,-168,152,-167v25,0,42,5,52,15r-10,33v-77,-50,-157,24,-157,112v0,73,72,94,119,58r11,-60r-36,0r5,-30r71,0r-20,112v-24,18,-55,26,-93,26v-63,0,-94,-33,-94,-99xm228,-335v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":243},"\u011f":{"d":"154,5v1,67,-111,90,-156,48r16,-25v39,24,97,25,107,-16v0,-35,-71,-10,-73,-45v0,-8,10,-15,30,-23v-33,3,-55,-23,-57,-52v-4,-65,74,-106,126,-71r16,-18r18,19r-17,18v17,45,-14,94,-50,105v-16,5,-25,11,-25,16v1,10,14,5,21,5v29,0,44,13,44,39xm134,-134v0,-17,-13,-32,-31,-31v-46,-7,-70,88,-19,91v26,2,50,-34,50,-60xm197,-272v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":180},"\u0130":{"d":"13,0r46,-258r36,0r-46,258r-36,0xm57,-289v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":100},"\u015e":{"d":"148,-107v43,77,-49,142,-133,99r11,-34v26,20,102,23,98,-24v-5,-55,-87,-58,-87,-122v0,-67,79,-87,132,-67r-10,34v-31,-25,-108,-7,-83,44v13,24,58,44,72,70xm42,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":173},"\u015f":{"d":"110,-99v53,33,3,103,-55,103v-20,0,-37,-5,-53,-15r17,-32v19,31,102,14,72,-26v-17,-22,-66,-25,-66,-65v0,-53,71,-74,120,-45r-15,31v-22,-31,-86,-13,-64,23v9,9,31,18,44,26xm42,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":145},"\u0106":{"d":"25,-93v0,-104,77,-199,187,-161r-10,35v-73,-46,-140,46,-140,119v0,81,76,91,121,47r-3,38v-14,13,-37,19,-67,19v-57,0,-88,-39,-88,-97xm198,-337r-40,59r-24,0r30,-59r34,0","w":215},"\u0107":{"d":"16,-69v0,-83,71,-149,147,-113r-6,28v-52,-33,-106,20,-106,79v0,51,55,63,91,34r-4,34v-54,27,-122,5,-122,-62xm160,-274r-40,59r-24,0r30,-59r34,0","w":165},"\u010c":{"d":"25,-93v0,-104,77,-199,187,-161r-10,35v-73,-46,-140,46,-140,119v0,81,76,91,121,47r-3,38v-14,13,-37,19,-67,19v-57,0,-88,-39,-88,-97xm225,-338r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":215},"\u010d":{"d":"16,-69v0,-83,71,-149,147,-113r-6,28v-52,-33,-106,20,-106,79v0,51,55,63,91,34r-4,34v-54,27,-122,5,-122,-62xm180,-275r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":165},"\u0111":{"d":"14,-66v0,-68,41,-126,105,-125v18,0,32,7,41,22r8,-42r-54,0r4,-23r54,0r6,-31r32,0r-6,31r20,0r-4,23r-20,0r-36,211r-33,0r4,-22v-34,46,-121,26,-121,-44xm122,-163v-44,0,-72,43,-72,90v0,52,48,62,76,31v20,-22,21,-60,28,-94v-2,-12,-16,-27,-32,-27","w":200},"\u00af":{"d":"-1,-271r0,-23r190,0r0,23r-190,0"},"\uf005":{"d":"45,-204v41,-12,-15,-61,26,-61v27,0,20,35,8,50v-8,10,-16,18,-27,23","w":132},"\u00b7":{"d":"36,-114v0,-14,12,-27,26,-27v14,0,27,13,27,27v0,14,-13,26,-27,26v-13,0,-26,-13,-26,-26","w":132},"\u0102":{"d":"165,0r-9,-54r-92,0r-30,54r-40,0r151,-261r9,0r51,261r-40,0xm137,-190r-59,110r75,0xm214,-335v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":219},"\u0103":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115xm198,-272v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":189},"\u0104":{"d":"205,0v-24,-4,-41,8,-42,26v-1,20,28,15,41,7r0,26v-32,15,-70,5,-71,-29v0,-18,10,-34,29,-48r-6,-36r-92,0r-30,54r-40,0r151,-261r9,0xm153,-80r-16,-110r-59,110r75,0","w":219},"\u0105":{"d":"176,0v-18,-2,-41,39,-8,40v8,0,15,-3,24,-7r0,26v-31,15,-70,5,-70,-29v0,-15,4,-28,15,-39v-2,-3,-3,-6,-4,-10v-33,37,-118,30,-118,-41v0,-64,44,-132,109,-132v30,0,52,6,65,16v-6,60,-41,117,-13,176xm152,-157v-53,-31,-102,35,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115","w":189},"\u010e":{"d":"219,-158v0,95,-61,159,-151,158r-56,0r45,-258v85,-16,162,14,162,100xm181,-160v0,-48,-44,-81,-95,-67r-32,194v82,11,127,-51,127,-127xm193,-338r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":220},"\u010f":{"d":"11,-66v0,-69,42,-125,106,-125v18,0,31,7,40,22r18,-96r32,0r-46,265r-33,0r4,-22v-35,47,-121,25,-121,-44xm120,-163v-44,0,-73,43,-73,90v0,52,48,62,76,31v20,-22,22,-59,28,-94v-3,-12,-15,-27,-31,-27xm216,-204v41,-12,-15,-61,26,-61v27,0,20,35,8,50v-8,10,-16,18,-27,23","w":248},"\u0110":{"d":"219,-158v0,95,-61,159,-151,158r-56,0r22,-124r-28,0r5,-28r27,0r19,-106v85,-16,162,14,162,100xm181,-160v0,-48,-44,-81,-95,-67r-12,75r40,0r-4,28r-41,0r-15,91v82,11,127,-51,127,-127","w":220},"\u0118":{"d":"162,0v-29,-3,-53,3,-53,26v0,19,27,15,41,7r0,26v-45,26,-93,-20,-60,-59r-82,0r46,-258r155,0r-5,32r-119,0r-13,72r86,0r-6,30r-85,0r-16,92r117,0","w":192},"\u0119":{"d":"55,-89v-17,57,48,83,89,49r-3,34v-25,9,-50,8,-50,32v0,20,28,15,42,7r0,26v-32,15,-71,5,-71,-29v0,-11,2,-21,8,-29v-35,-7,-52,-33,-52,-79v-1,-62,46,-115,108,-114v34,0,61,14,61,46v0,58,-82,82,-132,57xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51","w":193},"\u011a":{"d":"85,-226r-13,72r86,0r-6,30r-85,0r-16,92r117,0r-6,32r-154,0r46,-258r155,0r-5,32r-119,0xm204,-338r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":192},"\u011b":{"d":"187,-146v0,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-64,24,-123,4,-123,-72v0,-62,46,-115,108,-114v34,0,61,14,61,46xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51xm197,-275r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":193},"\u0139":{"d":"15,0r45,-258r36,0r-40,226r117,0r-6,32r-152,0xm136,-337r-40,59r-24,0r30,-59r34,0","w":182},"\u013a":{"d":"86,-21r-4,25v-66,-4,-62,-35,-48,-99r34,-170r35,0r-42,222v0,14,8,22,25,22xm138,-337r-40,59r-24,0r30,-59r34,0","w":115},"\u013d":{"d":"15,0r45,-258r36,0r-40,226r117,0r-6,32r-152,0xm135,-201v41,-12,-15,-61,26,-61v27,0,20,35,8,50v-8,10,-16,18,-27,23","w":182},"\u013e":{"d":"84,-21r-4,25v-66,-4,-62,-35,-48,-99r34,-170r35,0r-42,222v0,14,8,22,25,22xm111,-204v41,-12,-15,-61,26,-61v27,0,20,35,8,50v-8,10,-16,18,-27,23","w":115},"\u013f":{"d":"15,0r45,-258r36,0r-40,226r117,0r-6,32r-152,0xm131,-118v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":182},"\u0140":{"d":"86,-21r-4,25v-66,-4,-62,-35,-48,-99r34,-170r35,0r-42,222v0,14,8,22,25,22xm127,-125v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":182},"\u0143":{"d":"176,4r-100,-183r-30,179r-36,0r46,-258r14,0r98,176r30,-176r35,0r-46,262r-11,0xm182,-337r-40,59r-24,0r30,-59r34,0","w":229},"\u0144":{"d":"128,0r22,-134v2,-46,-64,-29,-78,-6r-25,140r-33,0r26,-154v0,-12,-2,-22,-4,-31r33,-7v3,17,4,26,4,28v24,-39,119,-43,113,24v-4,49,-16,93,-23,140r-35,0xm180,-274r-40,59r-24,0r30,-59r34,0","w":196},"\u0147":{"d":"176,4r-100,-183r-30,179r-36,0r46,-258r14,0r98,176r30,-176r35,0r-46,262r-11,0xm216,-338r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":229},"\u0148":{"d":"128,0r22,-134v2,-46,-64,-29,-78,-6r-25,140r-33,0r26,-154v0,-12,-2,-22,-4,-31r33,-7v3,17,4,26,4,28v24,-39,119,-43,113,24v-4,49,-16,93,-23,140r-35,0xm198,-275r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":196},"\u0150":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-53,0,-91,79,-90,132v0,39,16,71,52,72v62,0,96,-71,95,-137v0,-44,-19,-67,-57,-67xm171,-328r-35,50r-25,0r25,-50r35,0xm236,-328r-35,50r-25,0r25,-50r35,0","w":242},"\u0151":{"d":"83,4v-45,0,-69,-28,-70,-73v-1,-64,43,-124,104,-123v45,1,72,25,71,71v-1,66,-37,124,-105,125xm113,-165v-44,2,-64,49,-65,94v0,32,13,47,40,47v42,0,66,-51,65,-95v0,-30,-13,-46,-40,-46xm137,-265r-35,50r-25,0r25,-50r35,0xm202,-265r-35,50r-25,0r25,-50r35,0","w":193},"\u0154":{"d":"206,-204v0,43,-31,81,-67,87r48,117r-40,0r-41,-111v-9,0,-21,0,-37,-1r-20,112r-37,0r46,-258v65,-4,148,-9,148,54xm168,-189v1,-40,-38,-42,-79,-37r-15,84v46,8,94,-6,94,-47xm169,-337r-40,59r-24,0r30,-59r34,0","w":209},"\u0155":{"d":"147,-155v-34,-27,-73,15,-79,47r-19,108r-34,0r34,-188r33,0r-5,30v21,-27,43,-40,79,-31xm163,-274r-40,59r-24,0r30,-59r34,0","w":149},"\u0158":{"d":"206,-204v0,43,-31,81,-67,87r48,117r-40,0r-41,-111v-9,0,-21,0,-37,-1r-20,112r-37,0r46,-258v65,-4,148,-9,148,54xm168,-189v1,-40,-38,-42,-79,-37r-15,84v46,8,94,-6,94,-47xm198,-338r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":209},"\u0159":{"d":"147,-155v-34,-27,-73,15,-79,47r-19,108r-34,0r34,-188r33,0r-5,30v21,-27,43,-40,79,-31xm178,-275r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":149},"\u015a":{"d":"148,-107v43,77,-49,142,-133,99r11,-34v26,20,102,23,98,-24v-5,-55,-87,-58,-87,-122v0,-67,79,-87,132,-67r-10,34v-31,-25,-108,-7,-83,44v13,24,58,44,72,70xm164,-337r-40,59r-24,0r30,-59r34,0","w":173},"\u015b":{"d":"110,-99v53,33,3,103,-55,103v-20,0,-37,-5,-53,-15r17,-32v19,31,102,14,72,-26v-17,-22,-66,-25,-66,-65v0,-53,71,-74,120,-45r-15,31v-22,-31,-86,-13,-64,23v9,9,31,18,44,26xm155,-274r-40,59r-24,0r30,-59r34,0","w":145},"\u0162":{"d":"146,-226r-40,226r-36,0r40,-226r-82,0r5,-32r203,0r-6,32r-84,0xm56,81v41,-12,-15,-61,26,-61v27,0,20,35,8,50v-8,10,-16,18,-27,23","w":209},"\u0163":{"d":"121,-2v-38,16,-99,3,-87,-53r22,-107r-21,0r5,-26r22,0r8,-40r38,-14r-13,54r52,0r-5,26r-52,0r-22,110v-2,30,32,31,55,21xm31,81v41,-12,-15,-61,26,-61v27,0,20,35,8,50v-8,10,-16,18,-27,23","w":151},"\u0164":{"d":"146,-226r-40,226r-36,0r40,-226r-82,0r5,-32r203,0r-6,32r-84,0xm203,-328r-65,60r-18,0r-42,-60r31,0r25,33r34,-33r35,0","w":209},"\u0165":{"d":"121,-2v-38,16,-99,3,-87,-53r22,-107r-21,0r5,-26r22,0r8,-40r38,-14r-13,54r52,0r-5,26r-52,0r-22,110v-2,30,32,31,55,21xm159,-181v41,-12,-15,-61,26,-61v27,0,20,35,8,50v-8,10,-16,18,-27,23","w":178},"\u016e":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61xm189,-309v0,20,-17,31,-39,31v-22,0,-39,-11,-39,-31v0,-39,78,-42,78,0xm174,-309v-2,-21,-46,-21,-47,0v0,11,7,16,23,16v12,1,24,-5,24,-16","w":233},"\u016f":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0xm164,-246v0,20,-17,31,-39,31v-22,0,-39,-11,-39,-31v0,-39,78,-42,78,0xm149,-246v-2,-21,-46,-21,-47,0v0,11,7,16,23,16v12,1,24,-5,24,-16","w":200},"\u0170":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61xm160,-328r-35,50r-25,0r25,-50r35,0xm225,-328r-35,50r-25,0r25,-50r35,0","w":233},"\u0171":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0xm139,-265r-35,50r-25,0r25,-50r35,0xm204,-265r-35,50r-25,0r25,-50r35,0","w":200},"\u0179":{"d":"14,0r0,-9r144,-217r-109,0r5,-32r154,0r0,9r-139,217r108,0r-5,32r-158,0xm182,-337r-40,59r-24,0r30,-59r34,0","w":198},"\u017a":{"d":"59,-30r94,0r-6,30r-146,0r0,-9r116,-149r-97,0r6,-30r147,0r0,9xm154,-274r-40,59r-24,0r30,-59r34,0","w":170},"\u017b":{"d":"14,0r0,-9r144,-217r-109,0r5,-32r154,0r0,9r-139,217r108,0r-5,32r-158,0xm116,-299v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":198},"\u017c":{"d":"59,-30r94,0r-6,30r-146,0r0,-9r116,-149r-97,0r6,-30r147,0r0,9xm91,-236v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":170},"\u00a4":{"d":"173,-43r-25,-26v-28,20,-61,20,-89,0r-25,26r-15,-16r25,-24v-19,-30,-19,-59,0,-89r-25,-24r15,-16r25,25v28,-19,61,-19,89,0r25,-25r15,16r-25,24v19,30,19,59,0,89r25,24xm103,-180v-29,0,-53,24,-53,52v0,29,23,53,53,53v30,0,53,-24,53,-53v0,-29,-24,-52,-53,-52"},"\u037e":{"d":"52,-162v0,-14,11,-26,26,-26v14,0,26,12,26,26v0,14,-12,27,-26,27v-14,0,-26,-12,-26,-27xm65,-51v32,1,29,47,13,70v-9,13,-24,26,-46,40r-8,-14v23,-16,34,-29,34,-41v0,-14,-20,-22,-17,-34v-1,-12,12,-21,24,-21","w":132},"\u0384":{"d":"166,-284r-35,58r-28,0r24,-58r39,0"},"\u0385":{"d":"158,-284r-26,62r-19,0r14,-62r31,0xm163,-247v0,-11,8,-20,19,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-19,-9,-19,-20xm59,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20"},"\u0386":{"d":"165,0r-8,-54r-93,0r-30,54r-40,0r151,-261r10,0r50,261r-40,0xm137,-190r-59,110r75,0xm87,-257r-36,61r-28,0r25,-61r39,0","w":219},"\u0387":{"d":"36,-114v0,-14,12,-27,26,-27v14,0,27,13,27,27v0,14,-13,26,-27,26v-13,0,-26,-13,-26,-26","w":132},"\u0388":{"d":"125,-226r-13,71r85,0r-5,30r-85,0r-17,93r117,0r-5,32r-154,0r45,-257r156,0r-6,31r-118,0xm66,-257r-36,61r-28,0r25,-61r39,0","w":232},"\u0389":{"d":"197,0r21,-125r-112,0r-22,125r-36,0r45,-257r37,0r-19,102r113,0r18,-102r36,0r-46,257r-35,0xm66,-257r-36,61r-28,0r25,-61r39,0","w":271},"\u038a":{"d":"48,0r46,-257r36,0r-46,257r-36,0xm66,-257r-36,61r-28,0r25,-61r39,0","w":135},"\u038c":{"d":"125,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,35,91,94v0,93,-47,172,-138,172xm169,-231v-60,0,-88,72,-90,132v-1,40,15,71,51,72v64,0,96,-72,96,-138v0,-44,-19,-66,-57,-66xm66,-257r-36,61r-28,0r25,-61r39,0","w":264},"\u038e":{"d":"178,-115r-21,115r-35,0r20,-115r-58,-142r37,0r43,109r82,-109r39,0xm66,-257r-36,61r-28,0r25,-61r39,0","w":256},"\u038f":{"d":"269,-167v0,58,-34,111,-66,139v11,-1,27,-2,48,-2r-6,30r-96,0r0,-9v51,-53,79,-82,83,-157v2,-40,-19,-66,-57,-66v-55,1,-91,55,-89,116v0,47,15,76,35,107r0,9r-99,0r5,-30v21,0,38,1,49,2v-66,-92,-6,-235,101,-235v59,0,92,37,92,96xm66,-257r-36,61r-28,0r25,-61r39,0","w":273},"\u0390":{"d":"86,-188v-4,62,-41,133,-11,188r-38,0v-29,-56,10,-129,15,-188r34,0xm105,-284r-26,62r-19,0r15,-62r30,0xm110,-247v0,-11,8,-20,19,-20v11,0,20,8,20,20v0,12,-9,20,-20,20v-11,0,-19,-9,-19,-20xm7,-247v0,-11,8,-20,19,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-19,-9,-19,-20","w":96},"\u0391":{"d":"165,0r-8,-54r-93,0r-30,54r-40,0r151,-261r10,0r50,261r-40,0xm137,-190r-59,110r75,0","w":219},"\u0392":{"d":"195,-85v0,85,-86,92,-180,85r46,-257v65,-12,139,1,139,56v0,27,-24,54,-48,57v29,5,43,25,43,59xm92,-229r-11,71v46,5,83,-6,83,-44v0,-27,-36,-33,-72,-27xm57,-30v47,7,99,-7,101,-51v2,-39,-39,-55,-83,-47","w":203},"\u0393":{"d":"207,-257r-5,31r-114,0r-40,226r-36,0r45,-257r150,0","w":185},"\u0395":{"d":"85,-226r-13,71r86,0r-6,30r-85,0r-16,93r116,0r-5,32r-154,0r46,-257r156,0r-7,31r-118,0","w":193},"\u0396":{"d":"14,0r0,-9r144,-217r-109,0r5,-31r154,0r0,8r-139,217r109,0r-6,32r-158,0","w":197},"\u0397":{"d":"160,0r22,-125r-112,0r-22,125r-36,0r45,-257r37,0r-19,102r113,0r18,-102r36,0r-46,257r-36,0","w":235},"\u0398":{"d":"106,4v-56,0,-87,-42,-86,-99v2,-87,47,-167,133,-167v60,0,94,34,94,94v0,92,-51,172,-141,172xm151,-231v-55,-2,-96,75,-94,132v0,41,15,72,54,72v64,2,101,-74,100,-138v-1,-42,-19,-65,-60,-66xm187,-148r-6,31r-100,0r6,-31r100,0","w":248},"\u0399":{"d":"13,0r46,-257r36,0r-46,257r-36,0","w":100},"\u039a":{"d":"153,0r-50,-118r-43,48r-13,70r-35,0r46,-257r35,0r-23,133r117,-133r41,0r-97,111r62,146r-40,0","w":207},"\u039b":{"d":"197,0r-41,0r-29,-187r-99,187r-41,0r149,-261r9,0","w":211},"\u039c":{"d":"219,0r-3,-159r-86,163r-9,0r-27,-164r-60,160r-33,0r91,-257r18,0r28,180r91,-180r18,0r8,257r-36,0","w":274},"\u039d":{"d":"176,4r-100,-183r-31,179r-35,0r46,-257r14,0r98,175r30,-175r35,0r-46,261r-11,0","w":229},"\u039e":{"d":"229,-257r-6,29r-71,0r-13,75r54,0r-5,28r-54,0r-17,95r73,0r-5,30r-181,0r5,-30r73,0r17,-95r-54,0r5,-28r54,0r13,-75r-72,0r6,-29r178,0","w":216},"\u039f":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-59,0,-88,71,-89,132v0,40,15,71,51,72v63,1,96,-71,95,-138v0,-44,-19,-66,-57,-66","w":242},"\u03a0":{"d":"235,-257r-45,257r-36,0r40,-226r-106,0r-40,226r-36,0r45,-257r178,0","w":229},"\u03a1":{"d":"205,-186v0,70,-68,104,-141,87r-18,99r-37,0r48,-257v76,-13,148,3,148,71xm69,-131v42,15,99,-4,99,-51v0,-44,-41,-55,-82,-44","w":195},"\u03a3":{"d":"212,-257r-5,31r-109,0r52,89r-94,105r117,0r-5,32r-175,0r0,-9r117,-128r-66,-112r0,-8r168,0","w":195},"\u03a4":{"d":"145,-226r-39,226r-36,0r40,-226r-82,0r5,-31r203,0r-6,31r-85,0","w":209},"\u03a5":{"d":"126,-115r-21,115r-35,0r20,-115r-58,-142r37,0r43,109r82,-109r39,0","w":205},"\u03a6":{"d":"109,-20v-79,2,-112,-87,-74,-154v21,-37,61,-66,114,-68r4,-26r35,0r-4,26v94,-1,113,118,55,179v-24,26,-55,41,-95,43r-5,27r-35,0xm144,-215v-70,-2,-114,94,-74,149v9,12,25,18,44,19xm149,-47v84,6,135,-161,29,-167","w":275},"\u03a7":{"d":"144,0r-43,-99r-73,99r-41,0r99,-135r-48,-123r37,1r35,94r74,-94r40,0r-99,126r58,131r-39,0","w":200},"\u03a8":{"d":"115,-62v-55,-4,-95,-37,-84,-98r18,-97r35,0v-6,63,-53,162,37,167r29,-167r35,0r-29,167v82,-3,81,-95,95,-167r36,0v-14,72,-15,156,-78,180v-17,7,-36,13,-58,15r-11,63r-36,0","w":273},"\u03aa":{"d":"13,0r46,-257r36,0r-46,257r-36,0xm102,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm19,-299v0,-11,8,-20,19,-20v11,0,20,8,20,20v0,12,-9,20,-20,20v-11,0,-19,-9,-19,-20","w":100},"\u03ab":{"d":"126,-115r-21,115r-35,0r20,-115r-58,-142r37,0r43,109r82,-109r39,0xm157,-299v0,-11,8,-20,19,-20v11,0,21,9,21,20v0,11,-10,20,-21,20v-11,0,-19,-10,-19,-20xm73,-299v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":205},"\u03ac":{"d":"17,-60v0,-65,46,-134,110,-132v29,0,51,5,65,16v-6,59,-41,119,-15,176r-34,0v-4,-7,-7,-16,-9,-25v-33,48,-117,35,-117,-35xm155,-157v-53,-31,-102,34,-102,96v0,51,64,42,76,13v12,-29,18,-76,26,-109xm177,-284r-34,58r-29,0r25,-58r38,0","w":196},"\u03ad":{"d":"33,-134v-1,-55,90,-74,135,-44r-13,28v-27,-21,-82,-24,-86,16v-2,24,33,25,57,22r-4,27v-34,-6,-76,5,-73,38v4,39,64,24,88,2r15,27v-40,29,-136,37,-139,-26v-1,-30,27,-47,50,-55v-18,-3,-29,-15,-30,-35xm162,-284r-34,58r-29,0r25,-58r38,0","w":167},"\u03ae":{"d":"151,-134v2,-47,-65,-27,-78,-6r-24,140r-34,0v6,-62,30,-120,23,-185r32,-7v3,17,5,26,5,28v24,-40,123,-41,112,23r-32,190r-37,9r31,-168v2,-10,2,-17,2,-24xm179,-284r-35,58r-28,0r24,-58r39,0","w":199},"\u03af":{"d":"86,-188v-4,62,-41,133,-11,188r-38,0v-29,-56,10,-129,15,-188r34,0xm118,-284r-34,58r-29,0r25,-58r38,0","w":96},"\u03b0":{"d":"90,-24v60,0,69,-100,67,-164r35,0v5,89,-21,188,-107,191v-53,1,-70,-42,-58,-97r20,-94r35,0r-25,129v0,23,11,35,33,35xm152,-284r-26,62r-19,0r14,-62r31,0xm157,-247v0,-11,8,-20,19,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-10,0,-19,-9,-19,-20xm53,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":197},"\u03b1":{"d":"17,-60v0,-65,46,-134,110,-132v29,0,51,5,65,16v-6,59,-41,119,-15,176r-34,0v-4,-7,-7,-16,-9,-25v-29,45,-117,37,-117,-35xm155,-157v-53,-31,-102,34,-102,96v0,51,64,42,76,13v12,-29,18,-76,26,-109","w":196},"\u03b2":{"d":"195,-215v1,32,-28,58,-54,65v31,5,53,28,53,61v0,58,-44,93,-106,93v-23,0,-75,-4,-70,-27v22,-93,4,-236,116,-243v34,-1,61,20,61,51xm160,-211v-9,-56,-72,-18,-77,12v-1,6,-4,19,-7,38v46,5,82,-13,84,-50xm158,-88v0,-43,-40,-50,-87,-47r-17,98v35,35,104,0,104,-51","w":203},"\u03b3":{"d":"23,-189v74,-5,66,80,76,140v33,-56,56,-101,69,-139r37,0v-30,71,-64,131,-105,183v-5,48,-17,72,-60,80r-6,-28v64,-17,29,-154,7,-198v-4,-8,-13,-11,-24,-11","w":189},"\u03b4":{"d":"15,-70v0,-68,42,-129,116,-118r-42,-68r0,-9r120,0r-5,27r-69,0v15,17,56,78,56,118v0,62,-41,125,-105,124v-46,-1,-71,-29,-71,-74xm90,-24v42,0,67,-55,66,-96v-1,-25,-4,-46,-34,-46v-47,0,-72,49,-72,97v0,30,14,45,40,45","w":196},"\u03b5":{"d":"33,-134v-1,-55,90,-74,135,-44r-13,28v-27,-21,-82,-24,-86,16v-2,24,33,25,57,22r-4,27v-34,-6,-76,5,-73,38v4,39,64,24,88,2r15,27v-40,29,-139,37,-139,-26v0,-26,17,-44,50,-55v-18,-3,-29,-15,-30,-35","w":167},"\u03b6":{"d":"14,-54v1,-73,78,-145,121,-184r-67,0r6,-27r116,0r0,9v-49,48,-85,87,-106,119v-27,40,-42,66,-25,101v29,15,89,4,89,51v0,41,-44,69,-89,56r7,-27v23,8,50,2,49,-22v-1,-20,-19,-21,-43,-21v-35,-1,-58,-19,-58,-55","w":158},"\u03b7":{"d":"151,-134v2,-47,-65,-27,-78,-6r-24,140r-34,0v6,-62,30,-120,23,-185r32,-7v3,17,5,26,5,28v24,-40,123,-41,112,23r-32,190r-37,9r31,-168v2,-10,2,-17,2,-24","w":199},"\u03b8":{"d":"26,-83v3,-79,31,-183,112,-183v46,0,64,36,64,86v0,79,-31,184,-111,184v-47,0,-67,-36,-65,-87xm166,-150v6,-41,7,-89,-32,-89v-29,0,-51,29,-65,89r97,0xm162,-123r-98,0v-9,42,-8,100,30,100v31,0,54,-33,68,-100","w":203},"\u03b9":{"d":"86,-188v-4,62,-41,133,-11,188r-38,0v-29,-56,10,-129,15,-188r34,0","w":96},"\u03ba":{"d":"92,-84r-35,29r-10,55r-33,0r33,-188r34,0r-16,92v59,-51,92,-83,103,-97r22,22v-18,20,-41,43,-72,68r60,103r-41,0","w":193},"\u03bb":{"d":"110,-193v-3,-41,-19,-53,-54,-39r-8,-28v49,-16,86,0,94,50r33,210r-37,0r-20,-151r-86,151r-40,0","w":190},"\u03bd":{"d":"195,-188v-25,63,-63,127,-114,192r-9,0r-53,-192r37,0r33,136v31,-47,54,-92,69,-136r37,0","w":180},"\u03be":{"d":"47,-192v0,-61,80,-92,141,-64r-12,28v-33,-23,-92,-9,-92,34v0,34,38,37,75,35r-5,27v-58,-9,-101,28,-104,72v-3,57,98,9,98,75v0,41,-44,69,-89,56r7,-27v23,8,50,2,49,-22v-1,-20,-19,-21,-43,-21v-37,0,-59,-20,-59,-56v1,-46,35,-76,74,-90v-23,-4,-40,-21,-40,-47","w":163},"\u03bf":{"d":"85,4v-45,0,-70,-29,-70,-73v-2,-63,44,-124,105,-123v45,1,70,25,70,71v1,64,-41,125,-105,125xm115,-165v-41,-1,-66,51,-65,94v0,32,13,47,40,47v42,0,65,-52,65,-95v0,-30,-13,-46,-40,-46","w":195},"\u03c1":{"d":"201,-115v0,81,-81,152,-151,103r-15,86r-35,0v26,-102,11,-263,128,-266v46,-1,73,30,73,77xm166,-117v0,-51,-57,-60,-81,-25v-18,25,-24,66,-30,104v52,41,111,-15,111,-79","w":207},"\u03c2":{"d":"37,-22v-65,-81,46,-220,144,-154r-14,27v-50,-43,-113,12,-113,71v0,27,16,43,48,48v33,5,50,20,50,45v-1,43,-42,67,-88,56r7,-27v23,8,49,1,48,-23v-2,-32,-64,-20,-82,-43","w":169},"\u03c3":{"d":"17,-70v3,-69,45,-118,120,-118r83,0r-5,28r-55,0v67,55,11,167,-72,164v-43,-2,-73,-30,-71,-74xm91,-24v64,0,87,-102,36,-136v-47,-1,-76,43,-76,87v0,27,13,49,40,49","w":207},"\u03c4":{"d":"169,-188r-5,28r-56,0v-15,71,-23,109,-23,115v-1,26,27,24,45,15r-2,29v-46,16,-89,-6,-76,-65r21,-94r-51,0r5,-28r142,0","w":155},"\u03c5":{"d":"90,-24v60,0,69,-100,67,-164r35,0v5,89,-21,188,-107,191v-53,1,-70,-42,-58,-97r20,-94r35,0r-25,129v0,23,11,35,33,35","w":197},"\u03c6":{"d":"105,-169v-45,22,-93,139,-3,146v20,-64,2,-165,84,-169v76,-3,73,118,29,158v-22,21,-49,35,-85,37r-12,71r-34,0r13,-71v-79,4,-100,-83,-61,-141v13,-21,30,-39,53,-54xm212,-119v0,-36,-29,-64,-48,-36v-21,31,-19,90,-29,132v49,-4,77,-42,77,-96","w":252},"\u03c7":{"d":"128,0r-33,-73r-55,73r-43,0r83,-98r-47,-90r39,0r31,66r51,-66r41,0r-78,91r51,97r-40,0","w":185},"\u03c8":{"d":"105,3v-52,-4,-87,-34,-76,-91r19,-100r34,0v-2,59,-56,157,28,165r29,-165r33,0r-29,165v78,-4,71,-97,86,-165r34,0v-16,88,-17,193,-124,191r-13,71r-34,0","w":266},"\u03c9":{"d":"183,-24v57,-5,65,-116,22,-150r24,-20v63,49,43,198,-49,198v-24,0,-39,-12,-46,-35v-28,57,-116,42,-116,-31v0,-60,34,-105,73,-132r21,23v-33,23,-57,59,-60,109v-2,43,37,46,57,23v21,-24,19,-62,26,-96r34,0v-5,40,-36,103,14,111","w":274},"\u03ca":{"d":"86,-188v-4,62,-41,133,-11,188r-38,0v-29,-56,10,-129,15,-188r34,0xm98,-247v0,-11,8,-20,19,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-19,-9,-19,-20xm14,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":96},"\u03cb":{"d":"90,-24v60,0,69,-100,67,-164r35,0v5,89,-21,188,-107,191v-53,1,-70,-42,-58,-97r20,-94r35,0r-25,129v0,23,11,35,33,35xm145,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20xm62,-247v0,-11,9,-20,20,-20v11,0,20,9,20,20v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":197},"\u03cc":{"d":"85,4v-45,0,-70,-29,-70,-73v-2,-63,44,-124,105,-123v45,1,70,25,70,71v1,64,-41,125,-105,125xm115,-165v-41,-1,-66,51,-65,94v0,32,13,47,40,47v42,0,65,-52,65,-95v0,-30,-13,-46,-40,-46xm173,-284r-34,58r-28,0r24,-58r38,0","w":195},"\u03cd":{"d":"90,-24v60,0,69,-100,67,-164r35,0v5,89,-21,188,-107,191v-53,1,-70,-42,-58,-97r20,-94r35,0r-25,129v0,23,11,35,33,35xm168,-284r-34,58r-29,0r25,-58r38,0","w":197},"\u03ce":{"d":"183,-24v57,-5,65,-116,22,-150r24,-20v63,49,43,198,-49,198v-24,0,-39,-12,-46,-35v-28,57,-116,42,-116,-31v0,-60,34,-105,73,-132r21,23v-33,23,-57,59,-60,109v-2,43,37,46,57,23v21,-24,19,-62,26,-96r34,0v-5,40,-36,103,14,111xm210,-284r-35,58r-29,0r25,-58r39,0","w":274},"\u0401":{"d":"89,-226r-13,71r85,0r-5,30r-85,0r-17,93r117,0r-5,32r-154,0r45,-257r156,0r-6,31r-118,0xm159,-299v0,-10,8,-20,19,-20v11,0,20,9,20,20v0,10,-10,21,-20,20v-10,0,-19,-10,-19,-20xm89,-299v0,-12,9,-20,19,-20v11,-1,20,10,20,20v1,11,-10,20,-20,20v-10,0,-19,-10,-19,-20","w":196},"\u0402":{"d":"210,-91v0,-42,-48,-43,-85,-33r-22,124r-36,0r40,-226r-71,0r5,-31r189,0r-5,31r-82,0r-13,72v57,-13,118,3,117,59v-2,59,-41,109,-111,95r6,-29v43,12,68,-23,68,-62","w":259},"\u0403":{"d":"207,-257r-5,31r-114,0r-40,226r-36,0r45,-257r150,0xm185,-337r-39,58r-25,0r30,-58r34,0","w":186},"\u0404":{"d":"21,-93v0,-104,77,-199,187,-161r-10,34v-58,-35,-121,19,-132,69r91,0r-5,29r-93,0v-6,53,11,95,59,95v21,0,41,-9,61,-26r-3,38v-14,13,-37,19,-67,19v-57,0,-88,-39,-88,-97","w":203},"\u0405":{"d":"145,-108v42,78,-48,143,-133,100r11,-34v27,20,102,23,98,-24v-5,-57,-87,-57,-87,-122v0,-67,79,-87,132,-67r-10,34v-34,-28,-114,1,-80,50v10,14,59,45,69,63","w":171},"\u0406":{"d":"17,0r45,-257r36,0r-45,257r-36,0","w":100},"\u0407":{"d":"13,0r46,-257r36,0r-46,257r-36,0xm97,-299v0,-10,8,-21,19,-20v10,0,20,9,20,20v0,11,-10,20,-20,20v-10,0,-19,-10,-19,-20xm26,-299v0,-10,9,-20,20,-20v11,0,20,10,20,20v1,11,-10,20,-20,20v-10,0,-21,-9,-20,-20","w":100},"\u0408":{"d":"117,-18v-25,34,-131,32,-115,-34r31,0v-5,34,55,27,62,11v24,-54,30,-150,45,-216r35,0v-17,76,-21,188,-58,239","w":168},"\u0409":{"d":"340,-97v0,85,-80,105,-175,97r42,-227r-55,0v-26,83,-50,191,-122,225v-9,4,-23,4,-37,4r6,-33v44,-5,53,-27,73,-66v24,-46,41,-104,58,-160r117,0r-18,98v57,-11,110,8,111,62xm205,-29v54,10,98,-14,98,-64v0,-37,-43,-47,-80,-38","w":353},"\u040a":{"d":"316,-97v0,85,-80,105,-174,97r21,-125r-94,0r-22,125r-35,0r45,-257r35,0r-17,102r94,0r18,-102r36,0r-18,98v56,-10,112,8,111,62xm181,-29v54,10,96,-15,99,-64v2,-36,-43,-47,-80,-38","w":329},"\u040b":{"d":"195,0v5,-49,41,-133,-29,-129v-13,0,-27,2,-41,5r-22,124r-36,0r40,-226r-71,0r5,-31r189,0r-6,31r-81,0r-13,72v62,-14,127,6,115,73r-15,81r-35,0","w":268},"\u040c":{"d":"140,-45v2,-54,-16,-77,-71,-76r-21,121r-36,0r45,-257r36,0v-4,34,-17,75,-16,106v54,-1,75,-22,91,-66v10,-30,26,-46,65,-41r-6,30v-20,0,-22,7,-29,25v-15,37,-38,60,-73,68v34,13,50,35,50,80v0,22,2,26,22,25r-6,31v-33,4,-52,-8,-51,-46xm193,-337r-40,58r-25,0r30,-58r35,0","w":220},"\u040e":{"d":"236,-257v-37,89,-71,158,-120,212v-28,31,-52,47,-104,47r7,-34v32,0,58,-13,79,-40r-64,-185r38,0r51,155v28,-43,52,-95,74,-155r39,0xm120,-335v-5,21,7,34,27,33v20,0,31,-12,35,-36r28,8v-9,35,-32,52,-68,52v-34,0,-60,-21,-52,-60","w":208},"\u040f":{"d":"236,-257r-45,257r-73,0r-11,66r-34,0r11,-66r-72,0r45,-257r36,0r-39,225r106,0r40,-225r36,0","w":229},"\u0410":{"d":"162,0r-8,-54r-93,0r-30,54r-40,0r151,-261r10,0r50,261r-40,0xm134,-190r-59,110r75,0","w":219},"\u0411":{"d":"192,-92v0,85,-86,99,-180,92r45,-257r146,0r-5,30r-110,0r-13,72v58,-9,117,7,117,63xm53,-30v58,9,97,-9,101,-59v3,-39,-47,-45,-85,-38","w":205},"\u0412":{"d":"192,-85v-2,82,-87,94,-180,85r46,-257v64,-12,139,-1,139,56v0,31,-22,53,-49,59v29,9,44,28,44,57xm88,-230r-12,73v46,6,85,-6,85,-45v0,-29,-37,-34,-73,-28xm155,-83v1,-44,-41,-49,-85,-45r-17,98v52,9,101,-8,102,-53","w":205},"\u0413":{"d":"207,-257r-5,31r-114,0r-40,226r-36,0r45,-257r150,0","w":186},"\u0414":{"d":"10,-30v63,-69,89,-127,126,-227r109,0r-41,227r28,0r-18,104r-33,0r13,-74r-171,0r-13,74r-33,0r18,-104r15,0xm205,-228r-48,0v-29,83,-65,149,-108,198r121,0","w":246},"\u0415":{"d":"89,-226r-13,71r85,0r-5,30r-85,0r-17,93r117,0r-5,32r-154,0r45,-257r156,0r-6,31r-118,0","w":196},"\u0416":{"d":"49,-258v35,-5,48,12,48,46v0,43,17,61,59,62r19,-107r35,0r-20,107v38,0,65,-21,78,-62v11,-34,24,-50,65,-46r-5,30v-21,-1,-22,6,-29,25v-14,38,-37,60,-69,68v31,13,47,41,47,81v0,21,1,25,19,24r-5,31v-33,4,-48,-9,-48,-46v0,-50,-13,-75,-58,-77r-22,122r-34,0r21,-122v-69,-4,-75,74,-105,113v-8,10,-30,13,-46,10r6,-31v21,0,21,-7,29,-27v15,-41,40,-68,74,-79v-29,-10,-44,-33,-44,-69v0,-20,-3,-24,-21,-23","w":319},"\u0417":{"d":"87,-153v57,12,94,-80,24,-80v-19,0,-38,5,-58,15r-9,-32v56,-20,138,-21,140,44v1,35,-30,60,-54,68v26,7,41,24,42,53v2,79,-100,109,-170,76r12,-34v41,31,123,19,122,-40v-1,-36,-37,-46,-77,-41r5,-29r23,0","w":186},"\u0418":{"d":"248,-262r-46,262r-36,0r31,-180r-176,184r-9,0r46,-261r36,0r-31,179r176,-184r9,0","w":241},"\u0419":{"d":"248,-262r-46,262r-36,0r31,-180r-176,184r-9,0r46,-261r36,0r-31,179r176,-184r9,0xm137,-335v-5,20,6,34,26,33v20,0,32,-12,36,-36r27,8v-9,35,-31,52,-67,52v-34,0,-62,-23,-52,-60","w":241},"\u041a":{"d":"140,-45v2,-54,-16,-77,-71,-76r-21,121r-36,0r45,-257r36,0v-4,34,-17,75,-16,106v54,-1,75,-22,91,-66v10,-30,26,-46,65,-41r-6,30v-20,0,-22,7,-29,25v-15,37,-38,60,-73,68v34,13,50,35,50,80v0,22,2,26,22,25r-6,31v-33,4,-52,-8,-51,-46","w":219},"\u041b":{"d":"249,-257r-45,257r-36,0r41,-226r-57,0v-26,84,-49,191,-122,224v-9,4,-22,4,-37,4r6,-33v44,-5,52,-27,73,-66v24,-45,43,-105,58,-160r119,0","w":242},"\u041c":{"d":"214,0r-4,-159r-85,163r-9,0r-28,-166r-59,162r-34,0r92,-257r18,0r29,180r91,-180r17,0r7,257r-35,0","w":270},"\u041d":{"d":"160,0r22,-125r-112,0r-22,125r-36,0r45,-257r37,0r-19,102r113,0r18,-102r36,0r-46,257r-36,0","w":235},"\u041e":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-59,0,-88,71,-89,132v0,40,15,71,51,72v63,1,96,-71,95,-138v0,-44,-19,-66,-57,-66","w":242},"\u041f":{"d":"235,-257r-45,257r-36,0r40,-226r-106,0r-40,226r-36,0r45,-257r178,0","w":229},"\u0420":{"d":"208,-186v0,70,-69,104,-142,87r-17,99r-37,0r47,-257v76,-13,149,2,149,71xm72,-131v41,15,98,-4,98,-51v0,-44,-40,-56,-81,-44","w":201},"\u0421":{"d":"21,-93v0,-104,77,-199,187,-161r-10,35v-73,-46,-140,46,-140,119v0,81,76,91,121,47r-3,38v-14,13,-37,19,-67,19v-57,0,-88,-39,-88,-97","w":203},"\u0422":{"d":"153,-226r-39,226r-36,0r39,-226r-81,0r5,-31r203,0r-6,31r-85,0","w":222},"\u0423":{"d":"236,-257v-37,89,-71,158,-120,212v-28,31,-52,47,-104,47r7,-34v32,0,58,-13,79,-40r-64,-185r38,0r51,155v28,-43,52,-95,74,-155r39,0","w":208},"\u0424":{"d":"108,-28v-91,3,-110,-112,-52,-166v24,-23,52,-37,88,-39r6,-30r35,0r-5,30v50,1,87,32,86,82v0,66,-53,123,-122,123r-6,32r-35,0xm148,-55v78,7,127,-143,27,-151xm140,-206v-78,-8,-126,143,-27,151","w":269},"\u0425":{"d":"148,0r-41,-102r-75,102r-41,0r103,-134r-52,-123r38,0r38,93r70,-93r41,0r-98,126r57,131r-40,0","w":207},"\u0426":{"d":"231,-257r-40,226r27,0r-18,105r-33,0r13,-74r-168,0r45,-257r36,0r-40,226r102,0r40,-226r36,0","w":232},"\u0427":{"d":"158,-104v-66,19,-136,-5,-119,-80r14,-73r36,0v-2,47,-42,130,28,130v14,0,29,-3,46,-7r22,-123r36,0r-45,257r-36,0","w":214},"\u0428":{"d":"327,-257r-45,257r-270,0r45,-257r35,0r-40,227r83,0r40,-227r35,0r-40,227r83,0r40,-227r34,0","w":320},"\u0429":{"d":"326,-257r-40,226r27,0r-19,105r-33,0r13,-74r-262,0r45,-257r35,0r-40,227r82,0r40,-227r35,0r-40,227r82,0r40,-227r35,0","w":326},"\u042a":{"d":"254,-97v0,86,-83,105,-179,97r39,-227r-78,0r5,-30r115,0r-18,98v57,-10,117,6,116,62xm217,-92v1,-40,-45,-46,-84,-39r-18,101v55,10,100,-14,102,-62","w":267},"\u042b":{"d":"188,-96v-2,83,-81,104,-176,96r45,-257r35,0r-17,98v57,-11,114,9,113,63xm52,-29v56,10,96,-14,99,-63v2,-37,-44,-48,-82,-39xm285,-257r-46,257r-34,0r45,-257r35,0","w":278},"\u042c":{"d":"194,-97v-1,88,-85,105,-182,97r45,-257r36,0r-18,98v58,-10,120,4,119,62xm53,-30v59,10,100,-13,104,-62v4,-39,-49,-46,-87,-38","w":207},"\u042d":{"d":"201,-164v0,112,-86,202,-197,156r11,-35v67,45,141,-14,146,-79r-94,0r6,-28r92,0v11,-73,-52,-103,-110,-67r-9,-33v80,-30,155,-5,155,86","w":204},"\u042e":{"d":"188,4v-64,0,-90,-62,-77,-129r-42,0r-22,125r-35,0r45,-257r35,0r-18,102r43,0v15,-59,50,-106,115,-107v55,-1,86,39,86,94v0,87,-44,172,-130,172xm228,-232v-55,0,-85,73,-84,133v0,48,16,73,49,73v60,1,90,-76,89,-139v0,-39,-16,-67,-54,-67","w":320},"\u042f":{"d":"43,-179v0,-73,88,-91,179,-78r-46,257r-35,0r19,-112v-55,-3,-84,17,-102,67v-11,34,-22,50,-62,46r5,-31v19,1,18,-6,24,-23v15,-40,37,-63,68,-70v-33,-8,-50,-27,-50,-56xm80,-179v0,38,43,41,86,39r15,-88v-50,-8,-101,4,-101,49","w":215},"\u0430":{"d":"15,-60v0,-65,46,-134,110,-132v29,0,51,5,65,16v-8,57,-40,117,-15,176r-34,0v-4,-7,-7,-16,-9,-25v-29,45,-117,37,-117,-35xm153,-157v-53,-31,-102,34,-102,96v0,51,63,41,76,13v12,-27,18,-76,26,-109","w":194},"\u0431":{"d":"94,4v-125,-3,-65,-210,-7,-242v25,-23,88,-19,122,-32r8,30v-30,16,-94,5,-118,29v-12,12,-24,28,-32,53v41,-40,138,-27,134,48v-4,59,-44,116,-107,114xm60,-127v-13,42,-10,103,39,103v63,0,103,-131,20,-131v-23,0,-53,10,-59,28","w":208},"\u0432":{"d":"50,-158v22,-43,134,-53,134,13v0,25,-20,44,-45,48v21,6,39,18,39,41v0,40,-41,63,-92,60v-22,-1,-67,-4,-72,-21v7,-32,16,-126,36,-141xm152,-142v-2,-16,-13,-26,-31,-26v-33,0,-52,21,-59,61v42,2,93,-2,90,-35xm144,-56v-1,-34,-50,-28,-86,-28r-10,52v24,19,98,16,96,-24","w":194},"\u0433":{"d":"116,-125v21,-11,9,-39,-18,-39v-14,0,-30,6,-48,16r-14,-30v46,-21,125,-25,127,33v2,56,-81,51,-110,80v-16,16,-6,41,24,41v21,0,42,-8,63,-21r-4,36v-48,21,-125,21,-126,-37v-12,-43,84,-67,106,-79","w":163},"\u0434":{"d":"175,-160v14,-71,-39,-98,-104,-74r-5,-32v85,-11,146,3,144,81v-3,82,-34,189,-120,189v-46,0,-73,-28,-75,-72v-4,-80,92,-150,160,-92xm49,-70v0,55,67,59,92,17v12,-21,24,-48,31,-84v-16,-12,-35,-18,-56,-18v-35,0,-67,46,-67,85","w":210},"\u0435":{"d":"185,-145v2,59,-84,78,-135,56v-8,62,51,82,92,49r-4,34v-61,24,-122,5,-122,-71v0,-62,47,-115,108,-115v34,0,61,15,61,47xm152,-141v0,-30,-50,-27,-69,-10v-11,10,-20,22,-27,38v34,13,96,7,96,-28","w":184},"\u0436":{"d":"50,-148v0,-11,-9,-15,-18,-12r6,-29v25,-4,42,8,42,33v0,30,13,43,45,43r13,-75r32,0r-13,75v68,8,40,-87,113,-76r-6,29v-9,-3,-19,1,-19,11v-11,29,-30,46,-55,51v24,9,36,28,38,58v0,10,6,15,17,12r-6,29v-26,4,-42,-7,-42,-35v0,-34,-15,-52,-45,-52r-15,86r-32,0r15,-86v-74,-9,-42,97,-118,87r6,-29v10,4,17,-6,20,-14v12,-32,32,-52,56,-58v-22,-7,-34,-23,-34,-48","w":265},"\u0437":{"d":"80,-111v42,0,61,-55,14,-54v-16,0,-33,5,-51,15r-9,-31v44,-17,122,-21,123,34v0,24,-14,40,-43,48v22,7,33,20,33,40v2,64,-98,78,-147,47r18,-32v26,27,91,30,94,-15v2,-26,-31,-30,-58,-26r5,-27v2,0,9,1,21,1","w":162},"\u0438":{"d":"136,-27v-24,46,-127,44,-113,-36r22,-125r35,0r-23,134v-1,37,45,36,67,16v35,-32,27,-99,42,-150r35,0r-34,188r-35,0","w":204},"\u0439":{"d":"136,-27v-24,46,-127,44,-113,-36r22,-125r35,0r-23,134v-1,37,45,36,67,16v35,-32,27,-99,42,-150r35,0r-34,188r-35,0xm106,-271v-7,19,7,33,26,32v19,0,30,-12,34,-36r27,8v-5,62,-115,73,-118,6v0,-3,0,-7,1,-13","w":204},"\u043a":{"d":"117,-34v0,-34,-19,-53,-54,-52r-16,86r-34,0r33,-188r35,0r-14,75v56,6,62,-42,86,-70v7,-8,24,-8,40,-6r-6,29v-10,-2,-17,1,-20,11v-10,29,-30,45,-56,51v24,9,39,29,39,58v0,11,7,15,17,12r-6,29v-27,4,-45,-7,-44,-35"},"\u043b":{"d":"206,-188r-34,188r-33,0r28,-160r-53,0v-17,75,-28,126,-78,156v-11,7,-24,6,-39,6r7,-31v21,0,36,-13,49,-39v13,-26,25,-66,36,-120r117,0","w":209},"\u043c":{"d":"206,0r1,-113r-81,116r-8,0r-37,-116r-46,113r-35,0r81,-192r9,0r44,137r95,-137r10,0r2,192r-35,0","w":264},"\u043d":{"d":"200,-188r-34,188r-34,0r15,-85r-84,0r-16,85r-34,0r33,-188r35,0r-14,75r85,0r13,-75r35,0","w":203},"\u043e":{"d":"85,4v-45,0,-71,-28,-70,-73v2,-66,38,-123,105,-123v45,0,70,25,70,71v0,63,-41,125,-105,125xm115,-165v-41,-1,-66,51,-65,94v0,32,13,47,40,47v42,0,66,-53,65,-95v0,-30,-13,-46,-40,-46","w":194},"\u043f":{"d":"150,-134v2,-48,-65,-27,-78,-6r-24,140r-34,0v6,-62,30,-120,23,-185r32,-7v3,17,4,26,4,28v29,-47,126,-37,112,42r-21,122r-36,0","w":199},"\u0440":{"d":"196,-121v5,86,-72,153,-148,112r-15,84r-33,0r37,-207v3,-17,3,-36,0,-53r33,-6v1,1,2,9,3,24v34,-42,134,-28,123,46xm53,-37v48,37,116,-13,107,-80v6,-52,-63,-56,-87,-26v-8,25,-14,76,-20,106","w":201},"\u0441":{"d":"16,-69v0,-83,71,-149,147,-113r-6,28v-52,-33,-106,20,-106,79v0,51,55,62,91,34r-4,34v-53,27,-122,4,-122,-62","w":164},"\u0442":{"d":"181,-167v27,-40,121,-35,107,41r-23,126r-34,0r22,-133v1,-44,-56,-35,-71,-6r-25,139r-34,0r24,-139v0,-44,-70,-20,-74,0r-25,139r-34,0r26,-154v0,-12,-2,-22,-4,-31r32,-7v2,8,4,17,4,25v17,-30,96,-36,109,0","w":302},"\u0443":{"d":"13,74r0,-33v39,-1,54,-6,67,-40v-18,-1,-29,-18,-34,-49r-23,-140r37,0r20,136v2,14,6,22,14,22r68,-158r38,0r-92,205v-20,42,-37,56,-95,57","w":181},"\u0444":{"d":"16,-66v0,-70,51,-154,121,-115v7,-60,17,-78,71,-89r3,21v-35,3,-37,36,-42,69v46,-28,95,0,95,58v0,69,-51,154,-121,114v-6,59,-18,77,-70,87r-3,-21v32,-3,37,-34,41,-66v-46,25,-95,3,-95,-58xm147,-33v51,39,85,-39,85,-89v0,-48,-34,-53,-67,-33xm134,-157v-53,-34,-86,36,-86,91v0,47,35,54,67,31","w":270},"\u0445":{"d":"128,0r-34,-73r-54,73r-43,0r82,-98r-47,-90r39,0r31,66r51,-66r41,0r-77,91r51,97r-40,0","w":185},"\u0446":{"d":"172,-50v-4,20,5,28,26,28r-16,84r-32,0r13,-60v-14,0,-23,-9,-25,-26v-34,45,-129,37,-115,-42r22,-122r36,0r-23,135v2,44,66,28,80,4r25,-139r34,0","w":212},"\u0447":{"d":"139,-76v-55,21,-123,3,-105,-66r9,-46r34,0v-5,35,-27,93,24,92v16,0,30,-2,43,-7r15,-85r34,0r-34,188r-33,0","w":196},"\u0448":{"d":"57,-53v-1,48,68,25,72,3r25,-138r34,0r-24,139v3,43,60,20,74,-1r25,-138r34,0r-32,188r-34,0r2,-21v-25,30,-87,38,-101,-3v-33,47,-122,35,-109,-38r23,-126r34,0","w":300},"\u0449":{"d":"271,-50v-4,20,4,30,26,28r-15,84r-33,0r12,-60v-15,-1,-22,-11,-24,-26v-25,31,-90,44,-105,0v-32,47,-121,34,-108,-38r23,-126r34,0r-23,135v-1,48,67,25,71,3r25,-138r34,0r-24,139v4,41,52,25,72,0r25,-139r34,0","w":310},"\u044a":{"d":"218,-64v0,73,-106,81,-160,51r28,-147r-62,0r6,-28r95,0r-14,75v48,-19,107,-5,107,49xm185,-62v-2,-38,-48,-36,-80,-25r-10,54v26,20,92,10,90,-29","w":232},"\u044b":{"d":"174,-64v0,73,-106,81,-160,51r34,-175r34,0r-15,75v48,-19,107,-5,107,49xm52,-33v26,19,88,11,88,-29v0,-38,-47,-36,-78,-25xm262,-188r-33,188r-34,0r33,-188r34,0","w":265},"\u044c":{"d":"179,-64v0,74,-109,81,-164,51r34,-175r33,0r-14,75v51,-19,111,-6,111,49xm52,-33v27,19,92,13,92,-29v0,-39,-47,-36,-81,-24","w":193},"\u044d":{"d":"159,-118v0,91,-70,146,-158,112r13,-31v46,28,99,11,108,-48r-76,0r4,-26r75,0v4,-54,-38,-65,-79,-44r-9,-30v62,-19,122,-2,122,67","w":164},"\u044e":{"d":"160,4v-49,1,-71,-39,-62,-89r-37,0r-15,85r-33,0r33,-188r33,0r-13,76r37,0v11,-42,43,-80,91,-80v40,0,64,26,64,67v1,68,-35,128,-98,129xm191,-165v-38,1,-64,56,-63,99v0,28,12,43,35,43v42,0,61,-56,62,-100v0,-28,-11,-42,-34,-42","w":263},"\u044f":{"d":"125,-191v20,1,62,-1,59,15r-31,176r-32,0r14,-76v-46,-2,-70,10,-80,46v-8,25,-26,35,-55,31r5,-28v26,3,22,-36,38,-43v8,-7,17,-13,30,-17v-25,-5,-37,-18,-37,-39v1,-40,41,-68,89,-65xm70,-130v2,31,35,31,69,30r10,-60v-24,-11,-82,-5,-79,30","w":190},"\u0451":{"d":"185,-145v2,59,-84,78,-135,56v-8,62,51,82,92,49r-4,34v-61,24,-122,5,-122,-71v0,-62,47,-115,108,-115v34,0,61,15,61,47xm152,-141v0,-30,-50,-27,-69,-10v-11,10,-20,22,-27,38v34,13,96,7,96,-28xm142,-239v-1,-11,9,-19,20,-19v11,0,19,8,19,19v0,11,-8,21,-19,20v-11,0,-20,-9,-20,-20xm72,-239v0,-11,8,-19,19,-19v12,0,20,7,20,19v0,11,-9,20,-20,20v-11,0,-19,-9,-19,-20","w":184},"\u0452":{"d":"150,-122v3,-52,-67,-30,-79,-9r-23,131r-34,0r36,-209r-25,0r4,-25r26,0r5,-31r33,0r-5,31r67,0r-5,25r-66,0r-8,51v25,-35,120,-33,109,30v-12,69,-8,190,-85,199v-10,2,-21,4,-34,4r1,-30v85,15,67,-120,83,-167","w":198},"\u0453":{"d":"116,-125v21,-11,9,-39,-18,-39v-14,0,-30,6,-48,16r-14,-30v46,-21,125,-25,127,33v2,56,-81,51,-110,80v-16,16,-6,41,24,41v21,0,42,-8,63,-21r-4,36v-48,21,-125,21,-126,-37v-12,-43,84,-67,106,-79xm158,-274r-39,59r-25,0r30,-59r34,0","w":163},"\u0454":{"d":"16,-69v0,-81,65,-149,147,-114r-6,28v-43,-23,-90,-5,-102,44r73,0r-5,26r-73,0v-10,63,52,75,92,45r-4,33v-53,27,-122,5,-122,-62","w":164},"\u0455":{"d":"103,-103v65,30,15,107,-47,107v-19,0,-37,-5,-53,-15r18,-32v16,23,81,28,77,-13v-4,-36,-73,-31,-71,-78v3,-54,70,-74,120,-45r-15,31v-22,-31,-87,-12,-65,22v6,10,24,17,36,23","w":148},"\u0456":{"d":"59,-239v0,-11,10,-24,23,-23v12,1,24,9,24,23v0,14,-11,23,-24,23v-14,0,-23,-12,-23,-23xm28,0r29,-160r-25,0r6,-28r58,0r-33,188r-35,0","w":104},"\u0457":{"d":"28,0r29,-160r-25,0r6,-28r58,0r-33,188r-35,0xm90,-239v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-9,21,-20,20v-11,0,-20,-9,-20,-20xm20,-239v0,-11,9,-19,20,-19v11,0,19,8,19,19v0,11,-8,20,-19,20v-11,0,-21,-9,-20,-20","w":104},"\u0458":{"d":"64,-239v0,-12,11,-23,23,-23v14,0,24,11,24,23v0,12,-9,23,-24,23v-14,0,-23,-10,-23,-23xm-40,73r2,-29v40,0,63,-15,69,-45r30,-159r-25,0r7,-28r57,0r-34,185v-10,54,-42,76,-106,76","w":108},"\u0459":{"d":"297,-64v0,74,-104,81,-158,51r28,-147r-53,0v-17,75,-28,126,-78,156v-11,7,-24,6,-39,6r7,-31v21,0,36,-13,49,-39v13,-26,25,-66,36,-120r117,0r-14,75v48,-19,105,-6,105,49xm264,-62v0,-37,-44,-37,-77,-26r-11,55v26,19,88,12,88,-29","w":311},"\u045a":{"d":"276,-64v0,74,-104,81,-158,51r14,-73r-69,0r-16,86r-34,0r33,-188r34,0r-13,74r70,0r15,-74r33,0r-15,75v48,-18,106,-6,106,49xm243,-62v-2,-36,-44,-37,-78,-26r-9,55v25,19,89,12,87,-29","w":290},"\u045b":{"d":"150,-115v8,-58,-65,-40,-79,-16r-23,131r-34,0r36,-209r-25,0r4,-25r26,0r5,-31r33,0r-5,31r67,0r-5,25r-66,0r-8,51v29,-41,122,-30,108,46r-20,112r-35,0","w":198},"\u045c":{"d":"117,-34v0,-34,-19,-53,-54,-52r-16,86r-34,0r33,-188r35,0r-14,75v56,6,62,-42,86,-70v7,-8,24,-8,40,-6r-6,29v-10,-2,-17,1,-20,11v-10,29,-30,45,-56,51v24,9,39,29,39,58v0,11,7,15,17,12r-6,29v-27,4,-45,-7,-44,-35xm170,-274r-39,59r-25,0r30,-59r34,0"},"\u045e":{"d":"13,74r0,-33v39,-1,54,-6,67,-40v-18,-1,-29,-18,-34,-49r-23,-140r37,0r20,136v2,14,6,22,14,22r68,-158r38,0r-92,205v-20,42,-37,56,-95,57xm87,-271v-5,20,7,32,26,32v19,0,31,-12,35,-36r27,8v-5,70,-135,68,-117,-7","w":181},"\u045f":{"d":"70,4v-86,-9,-28,-128,-24,-192r35,0r-23,134v3,45,62,34,83,5r25,-139r35,0r-33,188r-34,0r2,-21v-11,11,-22,18,-36,22r-12,63r-33,0","w":204},"\u0490":{"d":"217,-313r-15,87r-114,0r-40,226r-36,0r45,-257r121,0r9,-56r30,0","w":186},"\u0491":{"d":"176,-235r-13,75r-87,0r-29,160r-34,0r33,-188r93,0r9,-47r28,0","w":158},"\u0100":{"d":"165,0r-9,-54r-92,0r-30,54r-40,0r151,-261r9,0r51,261r-40,0xm137,-190r-59,110r75,0xm223,-303r-4,25r-130,0r4,-25r130,0","w":219},"\u0101":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115xm193,-240r-4,25r-130,0r4,-25r130,0","w":189},"\u0108":{"d":"25,-93v0,-104,77,-199,187,-161r-10,35v-73,-46,-140,46,-140,119v0,81,76,91,121,47r-3,38v-14,13,-37,19,-67,19v-57,0,-88,-39,-88,-97xm179,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":215},"\u0109":{"d":"16,-69v0,-83,71,-149,147,-113r-6,28v-52,-33,-106,20,-106,79v0,51,55,63,91,34r-4,34v-54,27,-122,5,-122,-62xm142,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":165},"\u010a":{"d":"25,-93v0,-104,77,-199,187,-161r-10,35v-73,-46,-140,46,-140,119v0,81,76,91,121,47r-3,38v-14,13,-37,19,-67,19v-57,0,-88,-39,-88,-97xm137,-299v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":215},"\u010b":{"d":"16,-69v0,-83,71,-149,147,-113r-6,28v-52,-33,-106,20,-106,79v0,51,55,63,91,34r-4,34v-54,27,-122,5,-122,-62xm100,-236v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":165},"\u0112":{"d":"85,-226r-13,72r86,0r-6,30r-85,0r-16,92r117,0r-6,32r-154,0r46,-258r155,0r-5,32r-119,0xm203,-303r-4,25r-130,0r4,-25r130,0","w":192},"\u0113":{"d":"187,-146v0,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-64,24,-123,4,-123,-72v0,-62,46,-115,108,-114v34,0,61,14,61,46xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51xm197,-240r-4,25r-130,0r4,-25r130,0","w":193},"\u0114":{"d":"85,-226r-13,72r86,0r-6,30r-85,0r-16,92r117,0r-6,32r-154,0r46,-258r155,0r-5,32r-119,0xm200,-335v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":192},"\u0115":{"d":"187,-146v0,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-64,24,-123,4,-123,-72v0,-62,46,-115,108,-114v34,0,61,14,61,46xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51xm191,-272v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":193},"\u0116":{"d":"85,-226r-13,72r86,0r-6,30r-85,0r-16,92r117,0r-6,32r-154,0r46,-258r155,0r-5,32r-119,0xm111,-299v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":192},"\u0117":{"d":"187,-146v0,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-64,24,-123,4,-123,-72v0,-62,46,-115,108,-114v34,0,61,14,61,46xm60,-113v32,13,94,7,94,-29v0,-14,-10,-22,-30,-22v-30,0,-52,17,-64,51xm105,-236v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":193},"\u011c":{"d":"20,-95v0,-94,61,-168,152,-167v25,0,42,5,52,15r-10,33v-77,-50,-157,24,-157,112v0,73,72,94,119,58r11,-60r-36,0r5,-30r71,0r-20,112v-24,18,-55,26,-93,26v-63,0,-94,-33,-94,-99xm184,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":243},"\u011d":{"d":"154,5v1,67,-111,90,-156,48r16,-25v39,24,97,25,107,-16v0,-35,-71,-10,-73,-45v0,-8,10,-15,30,-23v-33,3,-55,-23,-57,-52v-4,-65,74,-106,126,-71r16,-18r18,19r-17,18v17,45,-14,94,-50,105v-16,5,-25,11,-25,16v1,10,14,5,21,5v29,0,44,13,44,39xm134,-134v0,-17,-13,-32,-31,-31v-46,-7,-70,88,-19,91v26,2,50,-34,50,-60xm131,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":180},"\u0120":{"d":"20,-95v0,-94,61,-168,152,-167v25,0,42,5,52,15r-10,33v-77,-50,-157,24,-157,112v0,73,72,94,119,58r11,-60r-36,0r5,-30r71,0r-20,112v-24,18,-55,26,-93,26v-63,0,-94,-33,-94,-99xm137,-299v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":243},"\u0121":{"d":"154,5v1,67,-111,90,-156,48r16,-25v39,24,97,25,107,-16v0,-35,-71,-10,-73,-45v0,-8,10,-15,30,-23v-33,3,-55,-23,-57,-52v-4,-65,74,-106,126,-71r16,-18r18,19r-17,18v17,45,-14,94,-50,105v-16,5,-25,11,-25,16v1,10,14,5,21,5v29,0,44,13,44,39xm134,-134v0,-17,-13,-32,-31,-31v-46,-7,-70,88,-19,91v26,2,50,-34,50,-60xm88,-236v0,-12,9,-21,21,-21v11,0,20,10,20,21v0,11,-9,21,-20,21v-12,0,-21,-9,-21,-21","w":180},"\u0122":{"d":"20,-95v0,-94,61,-168,152,-167v25,0,42,5,52,15r-10,33v-77,-50,-157,24,-157,112v0,73,72,94,119,58r11,-60r-36,0r5,-30r71,0r-20,112v-24,18,-55,26,-93,26v-63,0,-94,-33,-94,-99xm110,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":243},"\u0123":{"d":"154,5v1,67,-111,90,-156,48r16,-25v39,24,97,25,107,-16v0,-35,-71,-10,-73,-45v0,-8,10,-15,30,-23v-33,3,-55,-23,-57,-52v-4,-65,74,-106,126,-71r16,-18r18,19r-17,18v17,45,-14,94,-50,105v-16,5,-25,11,-25,16v1,10,14,5,21,5v29,0,44,13,44,39xm134,-134v0,-17,-13,-32,-31,-31v-46,-7,-70,88,-19,91v26,2,50,-34,50,-60xm112,-260v-1,11,15,16,15,27v0,11,-7,18,-19,18v-13,0,-19,-9,-19,-26v0,-20,9,-36,27,-50r10,10v-9,10,-13,10,-14,21","w":180},"\u0124":{"d":"160,0r22,-124r-112,0r-22,124r-36,0r45,-258r37,0r-19,104r113,0r18,-104r36,0r-46,258r-36,0xm179,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":235},"\u0125":{"d":"77,-168v33,-42,122,-28,108,50r-21,118r-35,0r23,-131v2,-49,-64,-34,-79,-9r-25,140r-34,0r46,-265r33,0xm160,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":200},"\u0126":{"d":"268,-218r-5,25r-27,0r-34,193r-36,0r22,-122r-114,0r-21,122r-36,0r34,-193r-27,0r4,-25r27,0r7,-39r36,0r-7,39r113,0r7,-39r36,0r-7,39r28,0xm200,-193r-113,0r-7,41r113,0","w":245},"\u0127":{"d":"76,-158v30,-43,120,-29,107,48r-19,110r-35,0r21,-122v3,-49,-64,-33,-79,-9r-23,131r-34,0r36,-209r-25,0r4,-25r26,0r5,-31r33,0r-5,31r67,0r-5,25r-66,0","w":199},"\u0128":{"d":"13,0r46,-258r36,0r-46,258r-36,0xm62,-315v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":100},"\u0129":{"d":"24,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0xm51,-252v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":110},"\u012a":{"d":"13,0r46,-258r36,0r-46,258r-36,0xm150,-303r-4,25r-130,0r4,-25r130,0","w":100},"\u012b":{"d":"24,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0xm139,-240r-4,25r-130,0r4,-25r130,0","w":110},"\u012c":{"d":"13,0r46,-258r36,0r-46,258r-36,0xm148,-335v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":100},"\u012d":{"d":"24,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0xm140,-272v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":110},"\u012e":{"d":"74,59v-32,15,-69,5,-70,-29v0,-14,5,-27,16,-38r44,-250r36,0r-46,258v-14,7,-21,15,-21,26v1,19,27,15,41,7r0,26","w":100},"\u012f":{"d":"78,-262v13,0,24,10,24,23v0,14,-10,23,-24,23v-13,0,-23,-10,-23,-23v0,-12,12,-23,23,-23xm78,59v-31,15,-70,5,-70,-29v0,-15,6,-28,18,-40r27,-150r-25,0r6,-28r57,0r-33,188v-14,7,-21,15,-21,26v1,19,27,15,41,7r0,26","w":110},"\u0132":{"d":"13,0r46,-258r36,0r-46,258r-36,0xm203,-19v-25,34,-130,34,-115,-33r30,0v-3,32,45,26,59,14v28,-45,33,-155,48,-220r36,0v-18,76,-21,187,-58,239","w":261},"\u0133":{"d":"55,-239v0,-12,12,-23,23,-23v12,0,24,10,24,23v0,12,-12,25,-24,23v-12,2,-23,-12,-23,-23xm24,0r29,-160r-25,0r6,-28r57,0r-33,188r-34,0xm158,-239v0,-11,12,-23,23,-23v12,0,24,11,24,23v0,12,-12,25,-24,23v-12,2,-23,-12,-23,-23xm55,73r1,-30v40,0,63,-14,69,-44r30,-159r-24,0r5,-28r58,0r-34,185v-10,54,-41,75,-105,76","w":210},"\u0134":{"d":"113,-19v-25,34,-130,34,-115,-33r30,0v-3,32,45,26,59,14v28,-45,33,-155,48,-220r36,0v-18,76,-21,187,-58,239xm167,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":171},"\u0135":{"d":"-24,73r1,-30v40,0,63,-14,69,-44r30,-159r-24,0r5,-28r58,0r-34,185v-10,54,-41,75,-105,76xm116,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":132},"\u0136":{"d":"153,0r-50,-118r-43,48r-12,70r-36,0r45,-258r36,0r-23,134r117,-134r41,0r-97,112r62,146r-40,0xm82,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":207},"\u0137":{"d":"78,-83r-14,11r-12,72r-33,0r44,-265r33,0r-24,154v44,-41,71,-69,81,-83r22,20v-19,21,-42,45,-71,73r71,101r-40,0xm78,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":181},"\u0138":{"d":"92,-84r-35,29r-10,55r-33,0r33,-188r34,0r-16,92v59,-51,92,-83,103,-97r22,22v-18,20,-41,43,-72,68r60,103r-41,0","w":193},"\u013b":{"d":"15,0r45,-258r36,0r-40,226r117,0r-6,32r-152,0xm76,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":182},"\u013c":{"d":"86,-21r-4,25v-66,-4,-62,-35,-48,-99r34,-170r35,0r-42,222v0,14,8,22,25,22xm43,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":115},"\u0145":{"d":"176,4r-100,-183r-30,179r-36,0r46,-258r14,0r98,176r30,-176r35,0r-46,262r-11,0xm85,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":229},"\u0146":{"d":"128,0r22,-134v2,-46,-64,-29,-78,-6r-25,140r-33,0r26,-154v0,-12,-2,-22,-4,-31r33,-7v3,17,4,26,4,28v24,-39,119,-43,113,24v-4,49,-16,93,-23,140r-35,0xm71,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":196},"\u0149":{"d":"5,-204v41,-12,-15,-61,26,-61v27,0,20,35,8,50v-8,10,-16,18,-27,23xm149,0r22,-134v2,-46,-64,-29,-78,-6r-25,140r-33,0r26,-154v0,-12,-2,-22,-4,-31r33,-7v3,17,4,26,4,28v24,-39,119,-43,113,24v-4,49,-16,93,-23,140r-35,0","w":217},"\u014a":{"d":"87,-234v43,-47,150,-36,140,44v-10,79,-7,189,-91,194v-17,0,-32,-5,-42,-14r17,-26v71,37,79,-84,79,-150v0,-63,-78,-51,-107,-14r-36,200r-35,0r45,-257r21,0","w":234},"\u014b":{"d":"135,-192v90,3,36,127,28,192v-6,51,-33,74,-87,75r5,-30v32,0,42,-13,47,-45r22,-134v2,-47,-64,-29,-78,-6r-25,140r-33,0r26,-155v0,-11,-2,-20,-4,-30r32,-7v3,17,5,26,5,28v14,-19,35,-28,62,-28","w":196},"\u014c":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-53,0,-91,79,-90,132v0,39,16,71,52,72v62,0,96,-71,95,-137v0,-44,-19,-67,-57,-67xm223,-303r-4,25r-130,0r4,-25r130,0","w":242},"\u014d":{"d":"83,4v-45,0,-69,-28,-70,-73v-1,-64,43,-124,104,-123v45,1,72,25,71,71v-1,66,-37,124,-105,125xm113,-165v-44,2,-64,49,-65,94v0,32,13,47,40,47v42,0,66,-51,65,-95v0,-30,-13,-46,-40,-46xm190,-240r-4,25r-130,0r4,-25r130,0","w":193},"\u014e":{"d":"103,4v-54,0,-83,-44,-83,-99v0,-83,50,-167,130,-167v60,0,91,34,91,94v0,94,-47,172,-138,172xm147,-231v-53,0,-91,79,-90,132v0,39,16,71,52,72v62,0,96,-71,95,-137v0,-44,-19,-67,-57,-67xm226,-335v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":242},"\u014f":{"d":"83,4v-45,0,-69,-28,-70,-73v-1,-64,43,-124,104,-123v45,1,72,25,71,71v-1,66,-37,124,-105,125xm113,-165v-44,2,-64,49,-65,94v0,32,13,47,40,47v42,0,66,-51,65,-95v0,-30,-13,-46,-40,-46xm187,-272v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":193},"\u0156":{"d":"206,-204v0,43,-31,81,-67,87r48,117r-40,0r-41,-111v-9,0,-21,0,-37,-1r-20,112r-37,0r46,-258v65,-4,148,-9,148,54xm168,-189v1,-40,-38,-42,-79,-37r-15,84v46,8,94,-6,94,-47xm76,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":209},"\u0157":{"d":"147,-155v-34,-27,-73,15,-79,47r-19,108r-34,0r34,-188r33,0r-5,30v21,-27,43,-40,79,-31xm25,10v35,-3,40,45,15,59v-11,7,-24,11,-40,11r-1,-17v17,0,35,-7,36,-22v0,-7,-5,-10,-14,-10","w":149},"\u015c":{"d":"148,-107v43,77,-49,142,-133,99r11,-34v26,20,102,23,98,-24v-5,-55,-87,-58,-87,-122v0,-67,79,-87,132,-67r-10,34v-31,-25,-108,-7,-83,44v13,24,58,44,72,70xm142,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":173},"\u015d":{"d":"110,-99v53,33,3,103,-55,103v-20,0,-37,-5,-53,-15r17,-32v19,31,102,14,72,-26v-17,-22,-66,-25,-66,-65v0,-53,71,-74,120,-45r-15,31v-22,-31,-86,-13,-64,23v9,9,31,18,44,26xm119,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":145},"\u0166":{"d":"236,-258r-6,32r-84,0r-16,89r55,0r-4,26r-56,0r-19,111r-36,0r19,-111r-55,0r4,-26r56,0r16,-89r-82,0r5,-32r203,0","w":209},"\u0167":{"d":"121,-2v-38,16,-105,1,-87,-53r8,-37r-24,0r5,-24r24,0r9,-46r-22,0r6,-26r22,0r8,-40r38,-14r-13,54r52,0r-5,26r-52,0r-10,46r47,0r-5,24r-47,0v-4,26,-19,68,19,67v9,0,19,-1,29,-6","w":151},"\u0168":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61xm132,-315v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":233},"\u0169":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0xm104,-252v24,0,49,30,64,0r15,0v-17,46,-49,40,-80,23v-8,0,-16,5,-22,14r-16,0v6,-17,20,-36,39,-37","w":200},"\u016a":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61xm219,-303r-4,25r-130,0r4,-25r130,0","w":233},"\u016b":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0xm192,-240r-4,25r-130,0r4,-25r130,0","w":200},"\u016c":{"d":"171,-17v-51,41,-162,26,-146,-62r32,-179r37,0r-33,188v-3,46,61,55,88,28v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-5,26,-16,46,-35,61xm216,-335v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":233},"\u016d":{"d":"132,-27v-24,48,-128,44,-113,-38r22,-123r35,0r-24,134v-1,37,46,34,67,15v36,-32,26,-99,42,-149r36,0r-35,188r-35,0xm191,-272v-7,38,-30,57,-69,57v-37,0,-55,-23,-47,-57r24,0v-4,19,5,30,28,30v22,0,35,-10,39,-30r25,0","w":200},"\u0172":{"d":"62,-81v-13,52,55,69,87,39v11,-10,18,-23,21,-40r31,-176r37,0r-32,180v-8,47,-41,76,-89,82v-18,8,-23,35,2,36v8,0,15,-3,24,-7r0,26v-43,25,-89,-16,-62,-56v-38,-6,-64,-34,-56,-81r32,-180r37,0","w":233},"\u0173":{"d":"132,-27v-24,48,-128,43,-113,-38r22,-123r35,0r-24,134v-1,37,44,35,66,16v36,-32,27,-99,43,-150r36,0r-35,188v-14,7,-22,15,-22,26v1,20,28,15,42,7r0,26v-32,15,-69,5,-71,-29v-1,-22,20,-33,21,-57","w":200},"\u0174":{"d":"209,4r-11,0r-30,-174r-89,174r-11,0r-35,-262r36,0r21,175r88,-175r12,0r26,174r81,-174r38,0xm212,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":306},"\u0175":{"d":"183,4r-9,0r-35,-123r-75,123r-9,0r-35,-193r34,0r21,120r70,-120r9,0r33,121r59,-121r35,0xm179,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":267},"\u0176":{"d":"126,-115r-21,115r-35,0r20,-115r-58,-143r37,0r43,110r82,-110r39,0xm163,-278r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":205},"\u0177":{"d":"5,74r0,-34v42,0,57,-11,67,-39v-17,0,-28,-16,-33,-49r-24,-140r37,0r20,136v2,13,7,21,15,21r68,-157r37,0r-94,210v-17,37,-38,52,-93,52xm133,-215r-22,-34r-38,34r-30,0r64,-60r18,0r43,60r-35,0","w":177},"\u017f":{"d":"18,0r32,-188v9,-60,49,-89,103,-72r-6,26v-35,-14,-55,3,-62,46r-31,188r-36,0","w":125},"\u01fa":{"d":"205,0r-40,0r-9,-54r-91,0r-31,54r-40,0r145,-232v-28,-2,-38,-38,-16,-53v7,-5,15,-8,24,-9r18,-36r35,0r-32,39v32,11,27,59,-12,59xm150,-247v13,1,24,-6,24,-16v0,-20,-48,-20,-48,0v0,11,8,16,24,16xm152,-80r-15,-101r-57,101r72,0","w":219},"\u01fb":{"d":"11,-60v0,-64,44,-132,109,-132v30,0,52,6,65,16v-7,58,-38,117,-16,176r-34,0v-2,-4,-4,-10,-6,-19v-33,37,-118,30,-118,-41xm148,-157v-53,-31,-102,34,-102,96v0,43,45,46,66,19v22,-28,26,-75,36,-115xm174,-237v0,20,-17,31,-39,31v-22,0,-39,-11,-39,-31v0,-39,78,-42,78,0xm159,-237v-2,-21,-46,-21,-47,0v0,11,7,16,23,16v12,1,24,-5,24,-16xm195,-340r-40,59r-24,0r30,-59r34,0","w":189},"\u01fc":{"d":"137,-54r-77,0r-33,54r-42,0r170,-258r172,0r-6,32r-117,0r-12,72r83,0r-5,30r-83,0r-17,92r115,0r-5,32r-152,0xm167,-220r-91,140r66,0xm273,-337r-40,59r-24,0r30,-59r34,0","w":312},"\u01fd":{"d":"301,-146v1,58,-82,82,-132,57v-17,57,48,83,89,49r-3,34v-40,14,-73,16,-97,-12v0,7,0,13,-1,18r-33,0v0,-5,1,-14,3,-27v-8,17,-33,31,-57,31v-39,-1,-59,-24,-59,-64v0,-64,44,-132,109,-132v24,0,45,2,60,7r-2,13v35,-29,122,-31,123,26xm146,-159v-62,-26,-101,37,-100,98v0,25,11,37,32,37v45,0,61,-84,68,-135xm174,-113v33,13,93,5,94,-31v1,-24,-57,-27,-70,-5v-10,10,-19,22,-24,36xm219,-274r-40,59r-24,0r30,-59r34,0","w":304},"\u01fe":{"d":"35,-37v-55,-116,63,-285,182,-204r18,-21r35,0r-37,42v36,102,-21,224,-128,224v-21,0,-38,-5,-52,-18r-16,18r-37,0xm63,-69r129,-145v-76,-61,-152,61,-129,145xm77,-42v75,52,145,-54,127,-145xm203,-337r-40,59r-24,0r30,-59r34,0","w":242},"\u01ff":{"d":"22,-29v-41,-89,53,-206,144,-148r14,-15r29,0r-30,32v39,89,-52,206,-143,149r-14,15r-32,0xm142,-153v-51,-39,-105,32,-93,96xm59,-35v54,38,104,-33,93,-97xm161,-274r-40,59r-24,0r30,-59r34,0","w":193},"\u1e80":{"d":"209,4r-11,0r-30,-174r-89,174r-11,0r-35,-262r36,0r21,175r88,-175r12,0r26,174r81,-174r38,0xm186,-278r-27,-59r34,0r11,59r-18,0","w":306},"\u1e81":{"d":"183,4r-9,0r-35,-123r-75,123r-9,0r-35,-193r34,0r21,120r70,-120r9,0r33,121r59,-121r35,0xm149,-215r-27,-59r34,0r11,59r-18,0","w":267},"\u1e82":{"d":"209,4r-11,0r-30,-174r-89,174r-11,0r-35,-262r36,0r21,175r88,-175r12,0r26,174r81,-174r38,0xm226,-337r-40,59r-24,0r30,-59r34,0","w":306},"\u1e83":{"d":"183,4r-9,0r-35,-123r-75,123r-9,0r-35,-193r34,0r21,120r70,-120r9,0r33,121r59,-121r35,0xm194,-274r-40,59r-24,0r30,-59r34,0","w":267},"\u1e84":{"d":"209,4r-11,0r-30,-174r-89,174r-11,0r-35,-262r36,0r21,175r88,-175r12,0r26,174r81,-174r38,0xm126,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm209,-299v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":306},"\u1e85":{"d":"183,4r-9,0r-35,-123r-75,123r-9,0r-35,-193r34,0r21,120r70,-120r9,0r33,121r59,-121r35,0xm92,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v1,11,-10,20,-20,20v-11,0,-20,-9,-20,-20xm175,-236v0,-11,9,-19,20,-19v11,0,20,8,20,19v0,11,-9,20,-20,20v-11,0,-20,-9,-20,-20","w":267},"\u1ef2":{"d":"126,-115r-21,115r-35,0r20,-115r-58,-143r37,0r43,110r82,-110r39,0xm131,-278r-27,-59r34,0r11,59r-18,0","w":205},"\u1ef3":{"d":"5,74r0,-34v42,0,57,-11,67,-39v-17,0,-28,-16,-33,-49r-24,-140r37,0r20,136v2,13,7,21,15,21r68,-157r37,0r-94,210v-17,37,-38,52,-93,52xm98,-215r-27,-59r34,0r11,59r-18,0","w":177},"\u2015":{"d":"15,-94r4,-23r230,0r-4,23r-230,0","w":264},"\u2017":{"d":"189,45r-190,0r0,-23r190,0r0,23xm189,89r-190,0r0,-23r190,0r0,23"},"\u2032":{"d":"52,-186r-24,0r29,-72r33,0","w":57},"\u2033":{"d":"57,-186r-24,0r30,-72r32,0xm110,-186r-24,0r29,-72r33,0","w":121},"\u203c":{"d":"62,-67r-13,0v0,-95,8,-123,21,-195r40,0v-14,80,-16,98,-48,195xm23,-21v0,-14,11,-25,25,-25v14,0,25,11,25,25v0,14,-12,25,-25,25v-13,0,-25,-11,-25,-25xm149,-67r-13,0v0,-95,8,-123,21,-195r40,0v-14,80,-16,98,-48,195xm110,-21v0,-14,11,-25,25,-25v14,0,25,11,25,25v0,14,-12,25,-25,25v-13,0,-25,-11,-25,-25","w":219},"\u203e":{"d":"138,-259r0,22r-139,0r0,-22r139,0"},"\u207f":{"d":"122,-262v65,2,24,89,21,135r-28,0r16,-92v-1,-30,-39,-24,-51,-4r-18,96r-27,0v5,-43,21,-84,16,-130r25,-5v2,7,4,11,3,18v9,-12,24,-18,43,-18","w":162},"\u20a4":{"d":"117,12v-33,-1,-59,-18,-98,-9r-5,-26v19,-11,40,-36,43,-69r-33,0r4,-23r32,0v1,-7,2,-17,2,-28r-30,0r3,-24r25,0v-9,-79,72,-114,130,-80r-17,27v-37,-26,-86,-6,-78,53r56,0r-4,24r-51,0v0,10,-1,19,-2,28r51,0r-4,23r-49,0v-5,33,-13,53,-24,61v27,14,78,18,95,-10r21,22v-10,16,-40,31,-67,31","w":190},"\u20a7":{"d":"288,-136v0,-51,68,-72,111,-43r-15,31v-18,-23,-59,-21,-62,10v5,34,64,36,64,78v0,58,-78,82,-120,49v-32,31,-95,12,-83,-46r22,-105r-23,0v-13,47,-62,79,-119,63r-19,99r-36,0r47,-257v72,-14,137,3,130,69r26,0r7,-39r38,-15r-13,54r41,0r-5,26r-41,0r-22,114v3,36,39,27,57,2v18,32,76,29,78,-10v-6,-36,-63,-33,-63,-80xm68,-131v41,16,82,-7,82,-58v0,-37,-30,-47,-64,-38","w":399},"\u2105":{"d":"29,-190v0,-51,50,-90,99,-66r0,22v-32,-23,-74,1,-74,41v0,33,39,32,61,16r-3,25v-37,15,-83,3,-83,-38xm240,-262r-187,268r-24,0r187,-268r24,0xm197,-112v30,0,46,17,46,46v0,39,-25,72,-64,71v-28,0,-46,-17,-46,-46v0,-40,25,-71,64,-71xm181,-15v25,1,38,-23,37,-51v0,-17,-8,-25,-24,-25v-36,0,-56,74,-13,76","w":251},"\u2113":{"d":"152,-14v-30,26,-105,28,-105,-33v0,-10,1,-22,4,-35r-17,9r-4,-28v11,-6,20,-11,28,-16v13,-66,25,-141,85,-145v31,-1,45,20,39,51v-7,36,-61,86,-94,110v-2,29,-20,80,21,77v8,0,18,-5,29,-15xm97,-143v34,-31,49,-47,52,-78v0,-9,-4,-14,-12,-14v-27,6,-33,60,-40,92"},"\u2116":{"d":"320,-129v0,43,-23,74,-63,75v-28,0,-43,-18,-42,-46v2,-40,24,-74,63,-74v28,0,42,15,42,45xm295,-23r-4,23r-86,0r4,-23r86,0xm220,-257r-46,259r-12,0r-86,-180r-32,178r-32,0r46,-260r11,0r87,180r32,-177r32,0xm261,-76v20,0,33,-26,33,-53v0,-15,-7,-23,-20,-23v-21,0,-32,25,-32,53v0,15,6,23,19,23","w":321},"\u212e":{"d":"11,-92v0,-85,101,-135,152,-71v16,20,24,43,24,69r-143,0r0,65v33,33,95,22,122,-3r8,10v-56,53,-163,20,-163,-70xm44,-156r0,50r111,0r0,-50v-26,-33,-84,-34,-111,0","w":197},"\u215b":{"d":"69,6r-23,0r172,-268r22,0xm52,-105r21,-118r-36,20r3,-20v25,-12,45,-24,57,-37r6,0r-28,155r-23,0xm242,-83v44,25,13,87,-35,87v-64,0,-40,-80,-4,-89v-34,-22,-11,-72,32,-72v49,0,40,63,7,74xm232,-137v-30,1,-28,35,-2,44v12,-10,18,-20,18,-30v0,-9,-5,-14,-16,-14xm210,-17v34,0,41,-45,9,-59v-19,9,-29,23,-29,39v0,13,7,20,20,20","w":293},"\u215c":{"d":"76,6r-23,0r171,-268r23,0xm249,-83v44,25,12,87,-36,87v-62,0,-40,-80,-3,-89v-35,-21,-10,-72,32,-72v49,0,40,63,7,74xm239,-137v-25,0,-31,33,-3,44v12,-10,18,-20,18,-30v0,-9,-4,-14,-15,-14xm217,-17v33,-1,42,-44,9,-59v-19,9,-29,23,-29,39v0,13,7,20,20,20xm117,-156v0,46,-62,69,-94,41r14,-19v16,19,58,9,58,-21v0,-15,-10,-23,-29,-23r4,-17v32,6,48,-47,10,-46v-10,0,-17,3,-23,8r-6,-16v18,-22,76,-15,74,19v-1,19,-15,38,-30,43v15,5,22,15,22,31","w":293},"\u215d":{"d":"76,6r-23,0r171,-268r23,0xm249,-83v44,25,12,87,-36,87v-62,0,-40,-80,-3,-89v-35,-21,-10,-72,32,-72v49,0,40,63,7,74xm239,-137v-25,0,-31,33,-3,44v12,-10,18,-20,18,-30v0,-9,-4,-14,-15,-14xm217,-17v33,0,42,-45,9,-59v-19,9,-29,23,-29,39v0,13,7,20,20,20xm33,-134v24,23,64,4,64,-31v0,-28,-38,-30,-54,-14r-6,-5r13,-76r77,0r-4,21r-57,0r-5,35v25,-16,62,2,59,33v6,54,-58,87,-99,56","w":293},"\u215e":{"d":"69,6r-23,0r172,-268r22,0xm242,-83v44,25,13,87,-35,87v-64,0,-40,-80,-4,-89v-34,-22,-10,-72,32,-72v49,0,40,63,7,74xm232,-137v-26,0,-30,33,-2,44v12,-10,18,-20,18,-30v0,-9,-5,-14,-16,-14xm210,-17v33,1,42,-45,9,-59v-19,9,-29,23,-29,39v0,13,7,20,20,20xm65,-105r-28,0v20,-40,31,-63,34,-68v14,-26,27,-48,39,-65r-71,0r4,-22r100,0v-27,58,-44,74,-78,155","w":293},"\u25a1":{"d":"26,-166r166,0r0,166r-166,0r0,-166xm39,-153r0,140r139,0r0,-140r-139,0","w":217},"\u25aa":{"d":"104,-160r0,82r-81,0r0,-82r81,0","w":127},"\u25ab":{"d":"104,-160r0,82r-81,0r0,-82r81,0xm91,-146r-55,0r0,54r55,0r0,-54","w":127},"\u25cf":{"d":"109,-24v-41,0,-78,-36,-78,-77v0,-41,37,-78,78,-78v41,0,77,37,77,78v0,41,-36,77,-77,77","w":217},"\u25e6":{"d":"20,-119v0,-23,21,-44,44,-44v23,0,44,21,44,44v0,23,-21,44,-44,44v-23,0,-44,-21,-44,-44xm95,-119v0,-16,-14,-31,-31,-31v-17,0,-31,15,-31,31v-1,17,15,31,31,31v16,0,31,-14,31,-31","w":127},"\u201b":{"d":"117,-245v0,26,-48,31,-28,61r9,14r-17,12v-16,-18,-24,-37,-24,-58v0,-23,12,-49,32,-49v15,0,28,7,28,20","w":132}}});
